# Online Attendance System (PHP + MySQL)

A business-style online attendance system with **Admin**, **Teacher**, and **Student** roles.

## Tech Stack
- PHP 8+ (works on XAMPP/WAMP/LAMP)
- MySQL 5.7+ / MariaDB
- Bootstrap 5 (UI)
- PDO (database)

## Features Implemented
- Admin: Teachers, Students, Classes/Sections, Subjects, Allocations, Attendance controls (view/edit/lock/delete), Leave approvals, Notices, Reports (CSV/Print), Settings
- Teacher: Dashboard, Student list (assigned classes), Mark attendance (no duplicates), Edit within allowed rule, Reports (CSV/Print), Notices, Profile
- Student: Dashboard, Attendance view (date-wise + subject percentage + CSV), Notices, Leave apply & history, Profile

## Installation (XAMPP)
1. Copy the project folder into:
   - `C:\xampp\htdocs\online-attendance-php` (Windows)  
   - or your server web root (Linux)
2. Create database:
   - Open phpMyAdmin → create DB named **attendance_system**
   - Import `database/database.sql`
   - Import `database/seed.sql`
3. Configure DB:
   - Edit `config/config.php` if needed (DB credentials & BASE_URL)
4. Run:
   - Open: `http://localhost/online-attendance-php/public/`

## Demo Credentials (Seed)
**Admin**
- Username: `admin`
- Password: `Admin@123`

**Teacher**
- Username: `amit` / Password: `Teacher@123`
- Username: `neha` / Password: `Teacher@123`

**Student**
- Username: `rohit` / Password: `Student@123`
- Username: `priya` / Password: `Student@123`

## Notes
- CSV export is implemented in Admin/Teacher/Student reports.
- For full database backup, use phpMyAdmin export (.sql).  
- Attendance locking prevents edits for that session.
