-- Seed data for Online Attendance System
-- After importing schema.sql, run this file to insert dummy data

USE attendance_system;

-- Settings
INSERT INTO settings (`key`, value) VALUES
('institute_name','Demo Institute'),
('session_year','2025-26'),
('edit_days','2'),
('cutoff_time','10:30')
ON DUPLICATE KEY UPDATE value=VALUES(value);

-- Admin profile + user (password: Admin@123)
INSERT INTO admin_profiles (id, name, email, phone) VALUES
(1,'System Admin','admin@example.com','9999999999')
ON DUPLICATE KEY UPDATE name=VALUES(name), email=VALUES(email), phone=VALUES(phone);

INSERT INTO users (id, role, profile_id, name, email, username, password_hash, is_active)
VALUES
(1,'admin',1,'System Admin','admin@example.com','admin', '$2y$10$6RaZDyQwNT6XSThyMKQG5eKrtgahRgrPDDm6jRVTXPAfxRhHtVEj2', 1)
ON DUPLICATE KEY UPDATE name=VALUES(name), email=VALUES(email), username=VALUES(username), is_active=VALUES(is_active);

-- Teachers + users (password: Teacher@123)
INSERT INTO teachers (id, name, email, phone, address, designation) VALUES
(1,'Amit Sharma','amit.teacher@example.com','9876543210','Delhi','Assistant Professor'),
(2,'Neha Verma','neha.teacher@example.com','9123456780','Noida','Lecturer')
ON DUPLICATE KEY UPDATE name=VALUES(name), email=VALUES(email), phone=VALUES(phone), address=VALUES(address), designation=VALUES(designation);

INSERT INTO users (id, role, profile_id, name, email, username, password_hash, is_active) VALUES
(2,'teacher',1,'Amit Sharma','amit.teacher@example.com','amit', '$2y$10$2BhShsIzxlypotx7CI0YsuF87cAagZVbBwSZlNmcQ1cafcgWst6nC', 1),
(3,'teacher',2,'Neha Verma','neha.teacher@example.com','neha', '$2y$10$2BhShsIzxlypotx7CI0YsuF87cAagZVbBwSZlNmcQ1cafcgWst6nC', 1)
ON DUPLICATE KEY UPDATE name=VALUES(name), email=VALUES(email), username=VALUES(username), is_active=VALUES(is_active);

-- Classes & Sections
INSERT INTO classes (id, name) VALUES
(1,'BCA 1st Year'),
(2,'BCA 2nd Year')
ON DUPLICATE KEY UPDATE name=VALUES(name);

INSERT INTO sections (id, class_id, name) VALUES
(1,1,'A'),
(2,1,'B'),
(3,2,'A')
ON DUPLICATE KEY UPDATE class_id=VALUES(class_id), name=VALUES(name);

-- Subjects
INSERT INTO subjects (id, name, code) VALUES
(1,'Programming Fundamentals','PF101'),
(2,'Database Management Systems','DBMS201'),
(3,'Web Technologies','WEB301')
ON DUPLICATE KEY UPDATE name=VALUES(name), code=VALUES(code);

-- Subject Assignments
INSERT INTO subject_assignments (id, subject_id, class_id, section_id) VALUES
(1,1,1,1),
(2,2,1,1),
(3,3,1,1),
(4,2,2,3),
(5,3,2,3)
ON DUPLICATE KEY UPDATE subject_id=VALUES(subject_id), class_id=VALUES(class_id), section_id=VALUES(section_id);

-- Allocations (Teacher-Class-Subject)
INSERT INTO allocations (id, teacher_id, class_id, section_id, subject_id) VALUES
(1,1,1,1,1),
(2,1,1,1,2),
(3,2,1,1,3),
(4,2,2,3,2)
ON DUPLICATE KEY UPDATE teacher_id=VALUES(teacher_id), class_id=VALUES(class_id), section_id=VALUES(section_id), subject_id=VALUES(subject_id);

-- Students + users (password: Student@123)
INSERT INTO students (id, name, roll_number, class_id, section_id, phone, email, address) VALUES
(1,'Rohit Kumar','01',1,1,'9000000001','rohit@example.com','Delhi'),
(2,'Priya Singh','02',1,1,'9000000002','priya@example.com','Delhi'),
(3,'Arjun Mehta','03',1,1,'9000000003','arjun@example.com','Noida'),
(4,'Sneha Gupta','04',1,1,'9000000004','sneha@example.com','Noida'),
(5,'Vivek Patel','05',1,1,'9000000005','vivek@example.com','Gurgaon'),
(6,'Ananya Rao','06',2,3,'9000000006','ananya@example.com','Gurgaon')
ON DUPLICATE KEY UPDATE name=VALUES(name), roll_number=VALUES(roll_number), class_id=VALUES(class_id), section_id=VALUES(section_id), phone=VALUES(phone), email=VALUES(email), address=VALUES(address);

INSERT INTO users (id, role, profile_id, name, email, username, password_hash, is_active) VALUES
(10,'student',1,'Rohit Kumar','rohit@example.com','rohit', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1),
(11,'student',2,'Priya Singh','priya@example.com','priya', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1),
(12,'student',3,'Arjun Mehta','arjun@example.com','arjun', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1),
(13,'student',4,'Sneha Gupta','sneha@example.com','sneha', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1),
(14,'student',5,'Vivek Patel','vivek@example.com','vivek', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1),
(15,'student',6,'Ananya Rao','ananya@example.com','ananya', '$2y$10$7rNtJV0hiAhZvk7nIZ7C8.LUmmy8uaK76wiDUXHVHTVGiCLESeNQu', 1)
ON DUPLICATE KEY UPDATE name=VALUES(name), email=VALUES(email), username=VALUES(username), is_active=VALUES(is_active);

-- Notices
INSERT INTO notices (id, title, content, target_role, is_active, created_by) VALUES
(1,'Attendance Rule','Attendance must be marked daily. Teachers can edit within 2 days.','all',1,1),
(2,'Holiday','Tomorrow is a holiday due to college event.','student',1,1)
ON DUPLICATE KEY UPDATE title=VALUES(title), content=VALUES(content), target_role=VALUES(target_role), is_active=VALUES(is_active);

-- Leave request (pending)
INSERT INTO leave_requests (id, student_id, date_from, date_to, reason, status) VALUES
(1,2, DATE_SUB(CURDATE(), INTERVAL 1 DAY), DATE_SUB(CURDATE(), INTERVAL 1 DAY), 'Medical appointment', 'pending')
ON DUPLICATE KEY UPDATE reason=VALUES(reason), status=VALUES(status);

-- Attendance sample sessions for today and yesterday
INSERT INTO attendance_sessions (id, teacher_id, class_id, section_id, subject_id, attendance_date, locked)
VALUES
(1,1,1,1,1, CURDATE(), 0),
(2,1,1,1,2, DATE_SUB(CURDATE(), INTERVAL 1 DAY), 1)
ON DUPLICATE KEY UPDATE teacher_id=VALUES(teacher_id), attendance_date=VALUES(attendance_date), locked=VALUES(locked);

-- Entries for session 1 (today PF101)
DELETE FROM attendance_entries WHERE session_id IN (1,2);

INSERT INTO attendance_entries (session_id, student_id, status, remark) VALUES
(1,1,'present',NULL),
(1,2,'absent','Not in class'),
(1,3,'present',NULL),
(1,4,'present',NULL),
(1,5,'leave','Approved leave');

-- Entries for session 2 (yesterday DBMS201 locked)
INSERT INTO attendance_entries (session_id, student_id, status, remark) VALUES
(2,1,'present',NULL),
(2,2,'present',NULL),
(2,3,'absent','Late'),
(2,4,'present',NULL),
(2,5,'present',NULL);
