<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/helpers.php';

function login_attempt($username, $password) {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT u.*, 
        CASE 
            WHEN u.role='student' THEN s.class_id 
            ELSE NULL 
        END as class_id,
        CASE 
            WHEN u.role='student' THEN s.section_id
            ELSE NULL
        END as section_id
        FROM users u
        LEFT JOIN students s ON (u.role='student' AND u.profile_id = s.id)
        WHERE u.username = ? OR u.email = ? LIMIT 1");
    $stmt->execute([$username, $username]);
    $u = $stmt->fetch();
    if (!$u) return [false, 'Invalid credentials.'];
    if ((int)$u['is_active'] !== 1) return [false, 'Account is deactivated.'];

    if (!password_verify($password, $u['password_hash'])) {
        return [false, 'Invalid credentials.'];
    }
    start_app_session();
    $_SESSION['user'] = [
        'id' => $u['id'],
        'role' => $u['role'],
        'username' => $u['username'],
        'email' => $u['email'],
        'name' => $u['name'],
        'profile_id' => $u['profile_id'],
        'class_id' => $u['class_id'],
        'section_id' => $u['section_id'],
    ];
    return [true, null];
}

function logout() {
    start_app_session();
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    session_destroy();
}

function change_password($user_id, $current, $new) {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT password_hash FROM users WHERE id=?");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch();
    if (!$row) return [false, 'User not found.'];
    if (!password_verify($current, $row['password_hash'])) return [false, 'Current password is incorrect.'];

    $hash = password_hash($new, PASSWORD_DEFAULT);
    $upd = $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?");
    $upd->execute([$hash, $user_id]);
    return [true, null];
}
?>
