<?php
require_once __DIR__ . '/helpers.php';
$u = current_user();
$role = $u['role'] ?? '';
$routes = [
  'admin' => [
    ['Dashboard', '/admin/index.php', 'bi bi-speedometer2'],
    ['Teachers', '/admin/teachers.php', 'bi bi-person-badge'],
    ['Students', '/admin/students.php', 'bi bi-people'],
    ['Classes & Sections', '/admin/classes.php', 'bi bi-diagram-3'],
    ['Subjects', '/admin/subjects.php', 'bi bi-journal-text'],
    ['Allocations', '/admin/allocations.php', 'bi bi-link-45deg'],
    ['Attendance', '/admin/attendance.php', 'bi bi-clipboard-check'],
    ['Leave Requests', '/admin/leaves.php', 'bi bi-envelope-paper'],
    ['Notices', '/admin/notices.php', 'bi bi-megaphone'],
    ['Reports', '/admin/reports.php', 'bi bi-file-earmark-spreadsheet'],
    ['Settings', '/admin/settings.php', 'bi bi-gear'],
    ['Profile', '/profile.php', 'bi bi-person-circle'],
  ],
  'teacher' => [
    ['Dashboard', '/teacher/index.php', 'bi bi-speedometer2'],
    ['My Students', '/teacher/students.php', 'bi bi-people'],
    ['Mark Attendance', '/teacher/mark_attendance.php', 'bi bi-clipboard-plus'],
    ['Attendance History', '/teacher/attendance_history.php', 'bi bi-clock-history'],
    ['Leave Requests', '/teacher/leaves.php', 'bi bi-envelope-paper'],
    ['Notices', '/teacher/notices.php', 'bi bi-megaphone'],
    ['Reports', '/teacher/reports.php', 'bi bi-file-earmark-spreadsheet'],
    ['Profile', '/profile.php', 'bi bi-person-circle'],
  ],
  'student' => [
    ['Dashboard', '/student/index.php', 'bi bi-speedometer2'],
    ['My Attendance', '/student/attendance.php', 'bi bi-clipboard-check'],
    ['Leave Requests', '/student/leaves.php', 'bi bi-envelope-plus'],
    ['Notices', '/student/notices.php', 'bi bi-megaphone'],
    ['Profile', '/profile.php', 'bi bi-person-circle'],
  ],
];
$menu = $routes[$role] ?? [];
$current_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
<div class="sidebar">
  <div class="brand mb-3">
    <div class="logo"></div>
    <div>
      <div class="text-white fw-bold"><?= e(APP_NAME) ?></div>
      <div class="small"><?= e(ucfirst($role)) ?> Panel</div>
    </div>
  </div>

  <div class="small text-uppercase fw-semibold mb-2" style="color:#94a3b8;">Navigation</div>
  <nav class="nav flex-column">
    <?php foreach ($menu as $item): 
      [$label,$href,$icon] = $item;
      $active = (strpos($current_path, str_replace(BASE_URL,'',$href)) !== false) ? 'active' : '';
    ?>
      <a class="nav-link <?= $active ?>" href="<?= BASE_URL . $href ?>"><i class="<?= e($icon) ?>"></i> <?= e($label) ?></a>
    <?php endforeach; ?>
    <hr class="border-secondary border-opacity-25">
    <a class="nav-link" href="<?= BASE_URL ?>/auth/logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
  </nav>

  <div class="mt-4 p-3 rounded-4" style="background:rgba(255,255,255,.06);">
    <div class="text-white fw-semibold"><?= e($u['name'] ?? $u['username'] ?? 'User') ?></div>
    <div class="small" style="color:#94a3b8;"><?= e($u['email'] ?? '') ?></div>
  </div>
</div>
<div class="main">
