<?php
require_once __DIR__ . '/../config/config.php';

function start_app_session() {
    if (session_status() === PHP_SESSION_NONE) {
        session_name(SESSION_NAME);
        session_start();
    }
}

function e($str) {
    return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8');
}

function redirect($path) {
    header("Location: " . BASE_URL . $path);
    exit;
}

function csrf_token() {
    start_app_session();
    if (empty($_SESSION[CSRF_KEY])) {
        $_SESSION[CSRF_KEY] = bin2hex(random_bytes(32));
    }
    return $_SESSION[CSRF_KEY];
}

function csrf_verify() {
    start_app_session();
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $token = $_POST['_token'] ?? '';
        if (!$token || !hash_equals($_SESSION[CSRF_KEY] ?? '', $token)) {
            http_response_code(403);
            die('Invalid CSRF token.');
        }
    }
}

function flash_set($key, $msg) {
    start_app_session();
    $_SESSION['flash'][$key] = $msg;
}

function flash_get($key) {
    start_app_session();
    $msg = $_SESSION['flash'][$key] ?? null;
    unset($_SESSION['flash'][$key]);
    return $msg;
}

function is_logged_in() : bool {
    start_app_session();
    return !empty($_SESSION['user']);
}

function current_user() {
    start_app_session();
    return $_SESSION['user'] ?? null;
}

function require_login($role = null) {
    if (!is_logged_in()) {
        redirect('/auth/login.php');
    }
    if ($role !== null) {
        $u = current_user();
        if (($u['role'] ?? '') !== $role) {
            http_response_code(403);
            die('Access denied.');
        }
    }
}

function now_date() {
    return date('Y-m-d');
}

function today_dmy() {
    return date('d M Y');
}

function has_permission($roles) {
    $u = current_user();
    return in_array($u['role'] ?? '', (array)$roles, true);
}

function setting($key, $default = null) {
    require_once __DIR__ . '/../config/db.php';
    $pdo = db();
    $stmt = $pdo->prepare("SELECT value FROM settings WHERE `key` = ?");
    $stmt->execute([$key]);
    $row = $stmt->fetch();
    return $row ? $row['value'] : $default;
}
?>
