<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$teachers = $pdo->query("SELECT * FROM teachers ORDER BY name")->fetchAll();
$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$sections = $pdo->query("SELECT s.*, c.name as class_name FROM sections s JOIN classes c ON c.id=s.class_id ORDER BY c.name, s.name")->fetchAll();
$subjects = $pdo->query("SELECT * FROM subjects ORDER BY name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'add') {
    $teacher_id = (int)$_POST['teacher_id'];
    $class_id = (int)$_POST['class_id'];
    $section_id = (int)$_POST['section_id'];
    $subject_id = (int)$_POST['subject_id'];
    try {
      $pdo->prepare("INSERT INTO allocations (teacher_id,class_id,section_id,subject_id) VALUES (?,?,?,?)")
          ->execute([$teacher_id,$class_id,$section_id,$subject_id]);
      flash_set('success','Allocation created.');
    } catch(Exception $e) {
      flash_set('error','Allocation already exists.');
    }
    redirect('/admin/allocations.php');
  }
  if ($act === 'delete') {
    $id = (int)$_POST['id'];
    $pdo->prepare("DELETE FROM allocations WHERE id=?")->execute([$id]);
    flash_set('success','Allocation removed.');
    redirect('/admin/allocations.php');
  }
}

$rows = $pdo->query("SELECT a.id, t.name as teacher_name, c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                     FROM allocations a
                     JOIN teachers t ON t.id=a.teacher_id
                     JOIN classes c ON c.id=a.class_id
                     JOIN sections sec ON sec.id=a.section_id
                     JOIN subjects sub ON sub.id=a.subject_id
                     ORDER BY t.name, c.name, sec.name, sub.name")->fetchAll();

$page_title = "Allocations | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
$error = flash_get('error');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Teacher–Class–Subject Allocation</h3>
  <div class="small-muted">Assign teachers to a class/section + subject.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="card p-4 mb-3">
  <h5 class="fw-bold">Create Allocation</h5>
  <form method="post" class="mt-2">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <input type="hidden" name="action" value="add">
    <div class="row g-2">
      <div class="col-md-3">
        <select class="form-select" name="teacher_id" required>
          <option value="">Teacher</option>
          <?php foreach($teachers as $t): ?><option value="<?= e($t['id']) ?>"><?= e($t['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <select class="form-select" name="class_id" required>
          <option value="">Class</option>
          <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <select class="form-select" name="section_id" required>
          <option value="">Section</option>
          <?php foreach($sections as $s): ?><option value="<?= e($s['id']) ?>"><?= e($s['class_name'].' - '.$s['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <div class="input-group">
          <select class="form-select" name="subject_id" required>
            <option value="">Subject</option>
            <?php foreach($subjects as $s): ?><option value="<?= e($s['id']) ?>"><?= e($s['code'].' - '.$s['name']) ?></option><?php endforeach; ?>
          </select>
          <button class="btn btn-primary">Assign</button>
        </div>
      </div>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>Teacher</th><th>Class</th><th>Section</th><th>Subject</th><th class="text-end">Action</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= e($r['teacher_name']) ?></td>
            <td><?= e($r['class_name']) ?></td>
            <td><?= e($r['section_name']) ?></td>
            <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
            <td class="text-end">
              <form method="post" onsubmit="return confirm('Remove allocation?');">
                <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= e($r['id']) ?>">
                <button class="btn btn-sm btn-outline-danger">Remove</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="5" class="text-center text-muted py-4">No allocations yet.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
