<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$subjects = $pdo->query("SELECT * FROM subjects ORDER BY name")->fetchAll();

$date = $_GET['date'] ?? now_date();
$class_id = (int)($_GET['class_id'] ?? 0);
$subject_id = (int)($_GET['subject_id'] ?? 0);

$action = $_GET['action'] ?? 'list';
$sess_id = (int)($_GET['session_id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'lock') {
    $sid = (int)$_POST['session_id'];
    $pdo->prepare("UPDATE attendance_sessions SET locked=1 WHERE id=?")->execute([$sid]);
    flash_set('success','Attendance locked for this session.');
    redirect('/admin/attendance.php?date=' . urlencode($date));
  }
  if ($act === 'unlock') {
    $sid = (int)$_POST['session_id'];
    $pdo->prepare("UPDATE attendance_sessions SET locked=0 WHERE id=?")->execute([$sid]);
    flash_set('success','Attendance unlocked for this session.');
    redirect('/admin/attendance.php?date=' . urlencode($date));
  }
  if ($act === 'delete_session') {
    $sid = (int)$_POST['session_id'];
    $pdo->prepare("DELETE FROM attendance_sessions WHERE id=?")->execute([$sid]);
    flash_set('success','Attendance record deleted.');
    redirect('/admin/attendance.php?date=' . urlencode($date));
  }
  if ($act === 'edit_entries') {
    $sid = (int)$_POST['session_id'];
    $reason = trim($_POST['reason'] ?? '');
    $entries = $_POST['status'] ?? [];
    $remarks = $_POST['remark'] ?? [];
    foreach ($entries as $student_id => $status) {
      $remark = trim($remarks[$student_id] ?? '');
      $pdo->prepare("UPDATE attendance_entries 
        SET status=?, remark=?, last_edit_reason=?, last_edited_by=?, last_edited_at=NOW()
        WHERE session_id=? AND student_id=?")
        ->execute([$status, $remark ?: null, $reason ?: null, (int)current_user()['id'], $sid, (int)$student_id]);
    }
    flash_set('success','Attendance updated with reason.');
    redirect('/admin/attendance.php?action=view&session_id=' . $sid);
  }
}

$success = flash_get('success');
$error = flash_get('error');

if ($action === 'view' && $sess_id) {
  $sess = $pdo->prepare("SELECT s.*, t.name as teacher_name, c.name as class_name, sec.name as section_name, sub.name as subject_name, sub.code
                         FROM attendance_sessions s
                         JOIN teachers t ON t.id=s.teacher_id
                         JOIN classes c ON c.id=s.class_id
                         JOIN sections sec ON sec.id=s.section_id
                         JOIN subjects sub ON sub.id=s.subject_id
                         WHERE s.id=?");
  $sess->execute([$sess_id]);
  $session = $sess->fetch();
  $entries = $pdo->prepare("SELECT ae.*, st.name as student_name, st.roll_number
                            FROM attendance_entries ae
                            JOIN students st ON st.id=ae.student_id
                            WHERE ae.session_id=?
                            ORDER BY st.roll_number+0, st.roll_number");
  $entries->execute([$sess_id]);
  $entryRows = $entries->fetchAll();
}

$page_title = "Attendance | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Attendance Controls</h3>
    <div class="small-muted">View, edit with reason, lock/unlock, or delete attendance sessions.</div>
  </div>
</div>

<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<?php if ($action === 'view' && !empty($session)): ?>
  <div class="card p-4 mb-3">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h5 class="fw-bold mb-1"><?= e($session['class_name'].' - '.$session['section_name']) ?> • <?= e($session['code'].' '.$session['subject_name']) ?></h5>
        <div class="small-muted">Date: <b><?= e($session['attendance_date']) ?></b> • Teacher: <?= e($session['teacher_name']) ?></div>
        <div class="mt-2">
          <?php if ((int)$session['locked']===1): ?>
            <span class="badge text-bg-warning">Locked</span>
          <?php else: ?>
            <span class="badge text-bg-success">Open</span>
          <?php endif; ?>
        </div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/attendance.php?date=<?= e($session['attendance_date']) ?>">Back</a>
        <form method="post" onsubmit="return confirm('Delete this attendance session?');">
          <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="action" value="delete_session">
          <input type="hidden" name="session_id" value="<?= e($session['id']) ?>">
          <button class="btn btn-outline-danger">Delete</button>
        </form>
        <?php if ((int)$session['locked']===1): ?>
          <form method="post">
            <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
            <input type="hidden" name="action" value="unlock">
            <input type="hidden" name="session_id" value="<?= e($session['id']) ?>">
            <button class="btn btn-primary">Unlock</button>
          </form>
        <?php else: ?>
          <form method="post">
            <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
            <input type="hidden" name="action" value="lock">
            <input type="hidden" name="session_id" value="<?= e($session['id']) ?>">
            <button class="btn btn-warning">Lock</button>
          </form>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="card p-4">
    <h6 class="fw-bold">Edit Attendance (Admin)</h6>
    <div class="small-muted">A reason is recommended for audit.</div>

    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="edit_entries">
      <input type="hidden" name="session_id" value="<?= e($session['id']) ?>">
      <div class="mb-3">
        <label class="form-label">Edit Reason</label>
        <input class="form-control" name="reason" placeholder="e.g., corrected wrong marking">
      </div>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Roll</th><th>Student</th><th>Status</th><th>Remark</th></tr></thead>
          <tbody>
            <?php foreach($entryRows as $r): ?>
              <tr>
                <td><?= e($r['roll_number']) ?></td>
                <td><?= e($r['student_name']) ?></td>
                <td style="max-width:260px;">
                  <select class="form-select" name="status[<?= e($r['student_id']) ?>]">
                    <option value="present" <?= ($r['status']==='present')?'selected':'' ?>>Present</option>
                    <option value="absent" <?= ($r['status']==='absent')?'selected':'' ?>>Absent</option>
                    <option value="leave" <?= ($r['status']==='leave')?'selected':'' ?>>Leave</option>
                  </select>
                </td>
                <td><input class="form-control" name="remark[<?= e($r['student_id']) ?>]" value="<?= e($r['remark']) ?>"></td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$entryRows): ?><tr><td colspan="4" class="text-center text-muted py-4">No entries.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
      <button class="btn btn-primary">Save Changes</button>
    </form>

    <hr class="my-4">
    <h6 class="fw-bold">Last Edit Info</h6>
    <div class="small-muted">Displayed per student row in DB (last edit fields).</div>
  </div>

<?php else: 
  $sql = "SELECT s.id, s.attendance_date, s.locked, t.name as teacher_name,
          c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name,
          (SELECT SUM(status='present') FROM attendance_entries ae WHERE ae.session_id=s.id) as present_count,
          (SELECT SUM(status='absent') FROM attendance_entries ae WHERE ae.session_id=s.id) as absent_count,
          (SELECT SUM(status='leave') FROM attendance_entries ae WHERE ae.session_id=s.id) as leave_count
          FROM attendance_sessions s
          JOIN teachers t ON t.id=s.teacher_id
          JOIN classes c ON c.id=s.class_id
          JOIN sections sec ON sec.id=s.section_id
          JOIN subjects sub ON sub.id=s.subject_id
          WHERE s.attendance_date = ?";
  $params = [$date];
  if ($class_id) { $sql .= " AND s.class_id=?"; $params[]=$class_id; }
  if ($subject_id) { $sql .= " AND s.subject_id=?"; $params[]=$subject_id; }
  $sql .= " ORDER BY c.name, sec.name, sub.name";
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll();
?>
  <div class="card p-3 mb-3">
    <form class="row g-2 p-2" method="get">
      <div class="col-md-3">
        <input type="date" class="form-control" name="date" value="<?= e($date) ?>">
      </div>
      <div class="col-md-3">
        <select class="form-select" name="class_id">
          <option value="0">All Classes</option>
          <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>" <?= ($class_id===(int)$c['id'])?'selected':'' ?>><?= e($c['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <select class="form-select" name="subject_id">
          <option value="0">All Subjects</option>
          <?php foreach($subjects as $s): ?><option value="<?= e($s['id']) ?>" <?= ($subject_id===(int)$s['id'])?'selected':'' ?>><?= e($s['code'].' - '.$s['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3 d-flex gap-2">
        <button class="btn btn-outline-primary w-100">Filter</button>
        <a class="btn btn-outline-secondary w-100" href="<?= BASE_URL ?>/admin/attendance.php">Today</a>
      </div>
    </form>
  </div>

  <div class="card p-3">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead><tr>
          <th>Date</th><th>Class</th><th>Section</th><th>Subject</th><th>Teacher</th>
          <th>Present</th><th>Absent</th><th>Leave</th><th>Status</th><th class="text-end">Action</th>
        </tr></thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?= e($r['attendance_date']) ?></td>
              <td><?= e($r['class_name']) ?></td>
              <td><?= e($r['section_name']) ?></td>
              <td><?= e($r['code'].' '.$r['subject_name']) ?></td>
              <td><?= e($r['teacher_name']) ?></td>
              <td><?= e((int)$r['present_count']) ?></td>
              <td><?= e((int)$r['absent_count']) ?></td>
              <td><?= e((int)$r['leave_count']) ?></td>
              <td><?= ((int)$r['locked']===1)?'<span class="badge text-bg-warning">Locked</span>':'<span class="badge text-bg-success">Open</span>' ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/admin/attendance.php?action=view&session_id=<?= e($r['id']) ?>">View/Edit</a>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="10" class="text-center text-muted py-4">No attendance sessions found for selected filters.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
