<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$success = flash_get('success');
$error = flash_get('error');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'add_class') {
    $name = trim($_POST['name']);
    $st = $pdo->prepare("INSERT INTO classes (name) VALUES (?)");
    try { $st->execute([$name]); flash_set('success','Class created.'); }
    catch(Exception $e){ flash_set('error','Class name already exists.'); }
    redirect('/admin/classes.php');
  }
  if ($act === 'edit_class') {
    $id = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $st = $pdo->prepare("UPDATE classes SET name=? WHERE id=?");
    $st->execute([$name,$id]);
    flash_set('success','Class updated.');
    redirect('/admin/classes.php');
  }
  if ($act === 'delete_class') {
    $id = (int)$_POST['id'];
    $c1 = $pdo->prepare("SELECT COUNT(*) c FROM students WHERE class_id=?");
    $c1->execute([$id]);
    $c2 = $pdo->prepare("SELECT COUNT(*) c FROM subject_assignments WHERE class_id=?");
    $c2->execute([$id]);
    if ((int)$c1->fetch()['c']>0 || (int)$c2->fetch()['c']>0) {
      flash_set('error','Cannot delete: students/subjects linked to this class.');
      redirect('/admin/classes.php');
    }
    $pdo->prepare("DELETE FROM classes WHERE id=?")->execute([$id]);
    flash_set('success','Class deleted.');
    redirect('/admin/classes.php');
  }

  if ($act === 'add_section') {
    $class_id = (int)$_POST['class_id'];
    $name = trim($_POST['name']);
    try {
      $pdo->prepare("INSERT INTO sections (class_id,name) VALUES (?,?)")->execute([$class_id,$name]);
      flash_set('success','Section created.');
    } catch(Exception $e) {
      flash_set('error','Section already exists for this class.');
    }
    redirect('/admin/classes.php');
  }

  if ($act === 'delete_section') {
    $sid = (int)$_POST['id'];
    $c1 = $pdo->prepare("SELECT COUNT(*) c FROM students WHERE section_id=?");
    $c1->execute([$sid]);
    $c2 = $pdo->prepare("SELECT COUNT(*) c FROM subject_assignments WHERE section_id=?");
    $c2->execute([$sid]);
    if ((int)$c1->fetch()['c']>0 || (int)$c2->fetch()['c']>0) {
      flash_set('error','Cannot delete: students/subjects linked to this section.');
      redirect('/admin/classes.php');
    }
    $pdo->prepare("DELETE FROM sections WHERE id=?")->execute([$sid]);
    flash_set('success','Section deleted.');
    redirect('/admin/classes.php');
  }
}

$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$sections = $pdo->query("SELECT s.*, c.name as class_name FROM sections s JOIN classes c ON c.id=s.class_id ORDER BY c.name, s.name")->fetchAll();

$page_title = "Classes & Sections | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Class & Section Management</h3>
  <div class="small-muted">Create and manage classes and sections. Delete is blocked when linked to students/subjects.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-4">
      <h5 class="fw-bold">Add Class</h5>
      <form method="post" class="mt-2">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="add_class">
        <div class="input-group">
          <input class="form-control" name="name" placeholder="e.g., BCA 1st Year" required>
          <button class="btn btn-primary">Add</button>
        </div>
      </form>

      <hr class="my-4">
      <h6 class="fw-bold mb-2">Existing Classes</h6>
      <?php foreach($classes as $c): ?>
        <div class="border rounded-4 p-3 mb-2">
          <div class="d-flex justify-content-between align-items-center">
            <div class="fw-semibold"><?= e($c['name']) ?></div>
            <div class="d-flex gap-2">
              <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="collapse" data-bs-target="#editC<?= e($c['id']) ?>">Edit</button>
              <form method="post" onsubmit="return confirm('Delete class?');">
                <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete_class">
                <input type="hidden" name="id" value="<?= e($c['id']) ?>">
                <button class="btn btn-sm btn-outline-danger">Delete</button>
              </form>
            </div>
          </div>
          <div class="collapse mt-2" id="editC<?= e($c['id']) ?>">
            <form method="post" class="d-flex gap-2">
              <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
              <input type="hidden" name="action" value="edit_class">
              <input type="hidden" name="id" value="<?= e($c['id']) ?>">
              <input class="form-control" name="name" value="<?= e($c['name']) ?>" required>
              <button class="btn btn-primary">Save</button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
      <?php if(!$classes): ?><div class="text-muted">No classes yet.</div><?php endif; ?>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-4">
      <h5 class="fw-bold">Add Section</h5>
      <form method="post" class="mt-2">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="add_section">
        <div class="row g-2">
          <div class="col-md-8">
            <select class="form-select" name="class_id" required>
              <option value="">Select class</option>
              <?php foreach($classes as $c): ?>
                <option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-4">
            <div class="input-group">
              <input class="form-control" name="name" placeholder="e.g., A" required>
              <button class="btn btn-primary">Add</button>
            </div>
          </div>
        </div>
      </form>

      <hr class="my-4">
      <h6 class="fw-bold mb-2">Existing Sections</h6>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Class</th><th>Section</th><th class="text-end">Action</th></tr></thead>
          <tbody>
            <?php foreach($sections as $s): ?>
              <tr>
                <td><?= e($s['class_name']) ?></td>
                <td><?= e($s['name']) ?></td>
                <td class="text-end">
                  <form method="post" onsubmit="return confirm('Delete section?');">
                    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="delete_section">
                    <input type="hidden" name="id" value="<?= e($s['id']) ?>">
                    <button class="btn btn-sm btn-outline-danger">Delete</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$sections): ?><tr><td colspan="3" class="text-center text-muted py-4">No sections yet.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
