<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
$pdo = db();

$counts = [
  'teachers' => (int)$pdo->query("SELECT COUNT(*) c FROM teachers")->fetch()['c'],
  'students' => (int)$pdo->query("SELECT COUNT(*) c FROM students")->fetch()['c'],
  'classes'  => (int)$pdo->query("SELECT COUNT(*) c FROM classes")->fetch()['c'],
  'subjects' => (int)$pdo->query("SELECT COUNT(*) c FROM subjects")->fetch()['c'],
];

$today = now_date();
$todayStmt = $pdo->prepare("SELECT 
  SUM(CASE WHEN status='present' THEN 1 ELSE 0 END) as present_count,
  SUM(CASE WHEN status='absent' THEN 1 ELSE 0 END) as absent_count,
  SUM(CASE WHEN status='leave' THEN 1 ELSE 0 END) as leave_count
  FROM attendance_entries ae
  JOIN attendance_sessions s ON s.id = ae.session_id
  WHERE s.attendance_date = ?");
$todayStmt->execute([$today]);
$todaySummary = $todayStmt->fetch() ?: ['present_count'=>0,'absent_count'=>0,'leave_count'=>0];

$month = date('Y-m');
$monthly = $pdo->prepare("SELECT c.name as class_name, sec.name as section_name,
  SUM(CASE WHEN ae.status='present' THEN 1 ELSE 0 END) present_count,
  SUM(CASE WHEN ae.status='absent' THEN 1 ELSE 0 END) absent_count,
  SUM(CASE WHEN ae.status='leave' THEN 1 ELSE 0 END) leave_count
  FROM attendance_entries ae
  JOIN attendance_sessions s ON s.id = ae.session_id
  JOIN classes c ON c.id = s.class_id
  JOIN sections sec ON sec.id = s.section_id
  WHERE DATE_FORMAT(s.attendance_date, '%Y-%m') = ?
  GROUP BY s.class_id, s.section_id
  ORDER BY c.name, sec.name");
$monthly->execute([$month]);
$monthlyRows = $monthly->fetchAll();

$page_title = "Admin Dashboard | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Dashboard</h3>
    <div class="small-muted">Overview for <?= e(today_dmy()) ?></div>
  </div>
  <a class="btn btn-outline-primary" href="<?= BASE_URL ?>/admin/attendance.php">View Attendance</a>
</div>

<div class="row g-3 mb-3">
  <div class="col-md-3">
    <div class="card p-3">
      <div class="kpi">
        <div>
          <div class="label">Teachers</div>
          <div class="value"><?= e($counts['teachers']) ?></div>
        </div>
        <i class="bi bi-person-badge fs-3 text-primary"></i>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="kpi">
        <div>
          <div class="label">Students</div>
          <div class="value"><?= e($counts['students']) ?></div>
        </div>
        <i class="bi bi-people fs-3 text-success"></i>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="kpi">
        <div>
          <div class="label">Classes</div>
          <div class="value"><?= e($counts['classes']) ?></div>
        </div>
        <i class="bi bi-diagram-3 fs-3 text-warning"></i>
      </div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="kpi">
        <div>
          <div class="label">Subjects</div>
          <div class="value"><?= e($counts['subjects']) ?></div>
        </div>
        <i class="bi bi-journal-text fs-3 text-danger"></i>
      </div>
    </div>
  </div>
</div>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-4 h-100">
      <h5 class="fw-bold">Today's Attendance Summary</h5>
      <div class="small-muted">Counts across all marked sessions today.</div>
      <div class="mt-3 d-flex flex-column gap-2">
        <div><span class="status-dot dot-green"></span> Present: <b><?= e((int)$todaySummary['present_count']) ?></b></div>
        <div><span class="status-dot dot-red"></span> Absent: <b><?= e((int)$todaySummary['absent_count']) ?></b></div>
        <div><span class="status-dot dot-amber"></span> Leave: <b><?= e((int)$todaySummary['leave_count']) ?></b></div>
      </div>
      <div class="mt-4">
        <a class="btn btn-primary" href="<?= BASE_URL ?>/admin/reports.php">Generate Reports</a>
      </div>
    </div>
  </div>
  <div class="col-lg-7">
    <div class="card p-4 h-100">
      <div class="d-flex align-items-center justify-content-between">
        <div>
          <h5 class="fw-bold mb-0">Monthly Overview (<?= e(date('M Y')) ?>)</h5>
          <div class="small-muted">Basic counts by class & section.</div>
        </div>
        <a class="btn btn-outline-secondary btn-sm" href="<?= BASE_URL ?>/admin/reports.php">Export CSV</a>
      </div>
      <div class="table-responsive mt-3">
        <table class="table align-middle">
          <thead>
            <tr>
              <th>Class</th>
              <th>Section</th>
              <th>Present</th>
              <th>Absent</th>
              <th>Leave</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$monthlyRows): ?>
            <tr><td colspan="5" class="text-center text-muted py-4">No attendance data for this month.</td></tr>
          <?php else: foreach($monthlyRows as $r): ?>
            <tr>
              <td><?= e($r['class_name']) ?></td>
              <td><?= e($r['section_name']) ?></td>
              <td><?= e((int)$r['present_count']) ?></td>
              <td><?= e((int)$r['absent_count']) ?></td>
              <td><?= e((int)$r['leave_count']) ?></td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
