<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  $id = (int)$_POST['id'];
  $remarks = trim($_POST['remarks'] ?? '');
  if ($act === 'approve' || $act === 'reject') {
    $status = ($act === 'approve') ? 'approved' : 'rejected';
    $pdo->prepare("UPDATE leave_requests SET status=?, remarks=?, reviewed_by=?, reviewed_at=NOW() WHERE id=?")
        ->execute([$status, $remarks ?: null, (int)current_user()['id'], $id]);
    flash_set('success', 'Leave request updated.');
    redirect('/admin/leaves.php');
  }
}

$rows = $pdo->query("SELECT lr.*, s.name as student_name, s.roll_number, c.name as class_name, sec.name as section_name
                     FROM leave_requests lr
                     JOIN students s ON s.id=lr.student_id
                     JOIN classes c ON c.id=s.class_id
                     JOIN sections sec ON sec.id=s.section_id
                     ORDER BY lr.created_at DESC")->fetchAll();

$page_title = "Leave Requests | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
$error = flash_get('error');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Leave / Request Handling</h3>
  <div class="small-muted">Approve or reject student leave requests with remarks.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr>
        <th>Student</th><th>Class</th><th>From</th><th>To</th><th>Reason</th><th>Status</th><th class="text-end">Action</th>
      </tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td>
              <div class="fw-semibold"><?= e($r['student_name']) ?></div>
              <div class="small-muted">Roll: <?= e($r['roll_number']) ?></div>
            </td>
            <td><?= e($r['class_name'].' - '.$r['section_name']) ?></td>
            <td><?= e($r['date_from']) ?></td>
            <td><?= e($r['date_to']) ?></td>
            <td style="max-width:360px;"><?= e($r['reason']) ?></td>
            <td>
              <?php if ($r['status']==='pending'): ?><span class="badge text-bg-secondary">Pending</span><?php endif; ?>
              <?php if ($r['status']==='approved'): ?><span class="badge text-bg-success">Approved</span><?php endif; ?>
              <?php if ($r['status']==='rejected'): ?><span class="badge text-bg-danger">Rejected</span><?php endif; ?>
              <?php if (!empty($r['remarks'])): ?><div class="small-muted mt-1">Remarks: <?= e($r['remarks']) ?></div><?php endif; ?>
            </td>
            <td class="text-end">
              <?php if ($r['status']==='pending'): ?>
                <button class="btn btn-sm btn-outline-success" data-bs-toggle="collapse" data-bs-target="#act<?= e($r['id']) ?>">Review</button>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php if ($r['status']==='pending'): ?>
          <tr class="collapse" id="act<?= e($r['id']) ?>">
            <td colspan="7">
              <form method="post" class="d-flex gap-2">
                <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= e($r['id']) ?>">
                <input class="form-control" name="remarks" placeholder="Remarks (optional)">
                <button class="btn btn-success" name="action" value="approve">Approve</button>
                <button class="btn btn-danger" name="action" value="reject">Reject</button>
              </form>
            </td>
          </tr>
          <?php endif; ?>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="7" class="text-center text-muted py-4">No leave requests.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
