<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'create') {
    $title = trim($_POST['title']);
    $content = trim($_POST['content']);
    $target = $_POST['target_role'] ?? 'all';
    $pdo->prepare("INSERT INTO notices (title, content, target_role, is_active, created_by) VALUES (?,?,?,?,?)")
        ->execute([$title,$content,$target,1,(int)current_user()['id']]);
    flash_set('success','Notice posted.');
    redirect('/admin/notices.php');
  }
  if ($act === 'toggle') {
    $id = (int)$_POST['id'];
    $pdo->prepare("UPDATE notices SET is_active=1-is_active WHERE id=?")->execute([$id]);
    flash_set('success','Notice status changed.');
    redirect('/admin/notices.php');
  }
  if ($act === 'delete') {
    $id = (int)$_POST['id'];
    $pdo->prepare("DELETE FROM notices WHERE id=?")->execute([$id]);
    flash_set('success','Notice deleted.');
    redirect('/admin/notices.php');
  }
}

$rows = $pdo->query("SELECT n.*, u.name as created_by_name FROM notices n
                     JOIN users u ON u.id=n.created_by
                     ORDER BY n.created_at DESC")->fetchAll();

$page_title = "Notices | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
$error = flash_get('error');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Notices</h3>
  <div class="small-muted">Post internal notices (no SMS/Email API).</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="card p-4 mb-3">
  <h5 class="fw-bold">Post a Notice</h5>
  <form method="post" class="mt-2">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <input type="hidden" name="action" value="create">
    <div class="row g-2">
      <div class="col-md-8">
        <input class="form-control" name="title" placeholder="Title" required>
      </div>
      <div class="col-md-4">
        <select class="form-select" name="target_role">
          <option value="all">All</option>
          <option value="teacher">Teachers</option>
          <option value="student">Students</option>
          <option value="admin">Admins</option>
        </select>
      </div>
      <div class="col-12">
        <textarea class="form-control" name="content" rows="3" placeholder="Write your notice..." required></textarea>
      </div>
    </div>
    <button class="btn btn-primary mt-2">Publish</button>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>Title</th><th>Target</th><th>Created</th><th>Status</th><th class="text-end">Action</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td>
              <div class="fw-semibold"><?= e($r['title']) ?></div>
              <div class="small-muted"><?= e(mb_strimwidth($r['content'],0,120,'...')) ?></div>
            </td>
            <td><?= e($r['target_role']) ?></td>
            <td>
              <div class="small-muted"><?= e($r['created_at']) ?></div>
              <div class="small-muted">By <?= e($r['created_by_name']) ?></div>
            </td>
            <td><?= ((int)$r['is_active']===1)?'<span class="badge text-bg-success">Active</span>':'<span class="badge text-bg-secondary">Inactive</span>' ?></td>
            <td class="text-end">
              <form method="post" class="d-inline" onsubmit="return confirm('Toggle notice status?');">
                <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="toggle">
                <input type="hidden" name="id" value="<?= e($r['id']) ?>">
                <button class="btn btn-sm btn-outline-primary">Toggle</button>
              </form>
              <form method="post" class="d-inline" onsubmit="return confirm('Delete notice?');">
                <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= e($r['id']) ?>">
                <button class="btn btn-sm btn-outline-danger">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="5" class="text-center text-muted py-4">No notices found.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
