<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();
$user = current_user();

$st = $pdo->prepare("SELECT ap.* FROM admin_profiles ap WHERE ap.id=?");
$st->execute([(int)$user['profile_id']]);
$profile = $st->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name']);
  $email = trim($_POST['email']);
  $phone = trim($_POST['phone']);
  $pdo->beginTransaction();
  $pdo->prepare("UPDATE admin_profiles SET name=?, email=?, phone=? WHERE id=?")->execute([$name,$email,$phone,(int)$user['profile_id']]);
  $pdo->prepare("UPDATE users SET name=?, email=? WHERE id=?")->execute([$name,$email,(int)$user['id']]);
  $pdo->commit();
  flash_set('success','Profile updated.');
  redirect('/admin/profile.php');
}

$page_title = "Admin Profile | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Admin Profile</h3>
  <div class="small-muted">View and update your profile.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>

<div class="card p-4" style="max-width:820px;">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">Name</label><input class="form-control" name="name" value="<?= e($profile['name']) ?>" required></div>
      <div class="col-md-6"><label class="form-label">Email</label><input class="form-control" type="email" name="email" value="<?= e($profile['email']) ?>" required></div>
      <div class="col-md-6"><label class="form-label">Phone</label><input class="form-control" name="phone" value="<?= e($profile['phone']) ?>"></div>
      <div class="col-md-6"><label class="form-label">Username</label><input class="form-control" value="<?= e($user['username']) ?>" disabled></div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/change_password.php">Change Password</a>
    </div>
  </form>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
