<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/reporting.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$sections = $pdo->query("SELECT s.*, c.name as class_name FROM sections s JOIN classes c ON c.id=s.class_id ORDER BY c.name, s.name")->fetchAll();
$subjects = $pdo->query("SELECT * FROM subjects ORDER BY name")->fetchAll();
$students = $pdo->query("SELECT id, name, roll_number FROM students ORDER BY name")->fetchAll();

$type = $_GET['type'] ?? 'student';
$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? now_date();
$class_id = (int)($_GET['class_id'] ?? 0);
$section_id = (int)($_GET['section_id'] ?? 0);
$subject_id = (int)($_GET['subject_id'] ?? 0);
$student_id = (int)($_GET['student_id'] ?? 0);
$export = (int)($_GET['export'] ?? 0);

$rows = [];

if (isset($_GET['run'])) {
  if ($type === 'student' && $student_id) {
    $st = $pdo->prepare("SELECT s.attendance_date, sub.code, sub.name as subject_name, st.roll_number, st.name as student_name, ae.status, ae.remark
                         FROM attendance_entries ae
                         JOIN attendance_sessions s ON s.id=ae.session_id
                         JOIN subjects sub ON sub.id=s.subject_id
                         JOIN students st ON st.id=ae.student_id
                         WHERE ae.student_id=? AND s.attendance_date BETWEEN ? AND ?
                         ORDER BY s.attendance_date, sub.code");
    $st->execute([$student_id, $from, $to]);
    $rows = $st->fetchAll();
    if ($export) {
      csv_download("student_report.csv", ["Date","Subject Code","Subject","Roll","Student","Status","Remark"],
        array_map(fn($r)=>[$r['attendance_date'],$r['code'],$r['subject_name'],$r['roll_number'],$r['student_name'],$r['status'],$r['remark']], $rows));
    }
  }

  if ($type === 'class' && $class_id && $section_id) {
    $st = $pdo->prepare("SELECT s.attendance_date, sub.code, sub.name as subject_name,
                         SUM(ae.status='present') present_count,
                         SUM(ae.status='absent') absent_count,
                         SUM(ae.status='leave') leave_count
                         FROM attendance_entries ae
                         JOIN attendance_sessions s ON s.id=ae.session_id
                         JOIN subjects sub ON sub.id=s.subject_id
                         WHERE s.class_id=? AND s.section_id=? AND s.attendance_date BETWEEN ? AND ?
                         GROUP BY s.attendance_date, s.subject_id
                         ORDER BY s.attendance_date, sub.code");
    $st->execute([$class_id,$section_id,$from,$to]);
    $rows = $st->fetchAll();
    if ($export) {
      csv_download("class_report.csv", ["Date","Subject Code","Subject","Present","Absent","Leave"],
        array_map(fn($r)=>[$r['attendance_date'],$r['code'],$r['subject_name'],$r['present_count'],$r['absent_count'],$r['leave_count']], $rows));
    }
  }

  if ($type === 'subject' && $subject_id && $class_id && $section_id) {
    $st = $pdo->prepare("SELECT st.roll_number, st.name as student_name,
                         SUM(ae.status='present') present_days,
                         SUM(ae.status='absent') absent_days,
                         SUM(ae.status='leave') leave_days,
                         COUNT(*) total,
                         ROUND((SUM(ae.status='present')/COUNT(*))*100,2) present_pct
                         FROM attendance_entries ae
                         JOIN attendance_sessions s ON s.id=ae.session_id
                         JOIN students st ON st.id=ae.student_id
                         WHERE s.subject_id=? AND s.class_id=? AND s.section_id=? AND s.attendance_date BETWEEN ? AND ?
                         GROUP BY st.id
                         ORDER BY st.roll_number+0, st.roll_number");
    $st->execute([$subject_id,$class_id,$section_id,$from,$to]);
    $rows = $st->fetchAll();
    if ($export) {
      csv_download("subject_report.csv", ["Roll","Student","Present Days","Absent Days","Leave Days","Total","Present %"],
        array_map(fn($r)=>[$r['roll_number'],$r['student_name'],$r['present_days'],$r['absent_days'],$r['leave_days'],$r['total'],$r['present_pct']], $rows));
    }
  }
}

$page_title = "Reports | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Reports & Export</h3>
  <div class="small-muted">Generate print-friendly reports and download as CSV.</div>
</div>

<div class="card p-4 mb-3">
  <form method="get" class="row g-2">
    <div class="col-md-3">
      <label class="form-label">Report Type</label>
      <select class="form-select" name="type">
        <option value="student" <?= ($type==='student')?'selected':'' ?>>Student (date range)</option>
        <option value="class" <?= ($type==='class')?'selected':'' ?>>Class/Section (date range)</option>
        <option value="subject" <?= ($type==='subject')?'selected':'' ?>>Subject Summary (date range)</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">From</label>
      <input type="date" class="form-control" name="from" value="<?= e($from) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">To</label>
      <input type="date" class="form-control" name="to" value="<?= e($to) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">CSV Export</label>
      <select class="form-select" name="export">
        <option value="0">No</option>
        <option value="1">Yes (Download)</option>
      </select>
    </div>

    <div class="col-12"><hr></div>

    <div class="col-md-4">
      <label class="form-label">Student</label>
      <select class="form-select" name="student_id">
        <option value="0">Select</option>
        <?php foreach($students as $s): ?>
          <option value="<?= e($s['id']) ?>" <?= ($student_id===(int)$s['id'])?'selected':'' ?>><?= e($s['roll_number'].' - '.$s['name']) ?></option>
        <?php endforeach; ?>
      </select>
      <div class="small-muted mt-1">Required for Student report</div>
    </div>
    <div class="col-md-4">
      <label class="form-label">Class</label>
      <select class="form-select" name="class_id">
        <option value="0">Select</option>
        <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>" <?= ($class_id===(int)$c['id'])?'selected':'' ?>><?= e($c['name']) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Section</label>
      <select class="form-select" name="section_id">
        <option value="0">Select</option>
        <?php foreach($sections as $s): ?><option value="<?= e($s['id']) ?>" <?= ($section_id===(int)$s['id'])?'selected':'' ?>><?= e($s['class_name'].' - '.$s['name']) ?></option><?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-6">
      <label class="form-label">Subject (for Subject Summary)</label>
      <select class="form-select" name="subject_id">
        <option value="0">Select</option>
        <?php foreach($subjects as $s): ?><option value="<?= e($s['id']) ?>" <?= ($subject_id===(int)$s['id'])?'selected':'' ?>><?= e($s['code'].' - '.$s['name']) ?></option><?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-6 d-flex align-items-end gap-2">
      <button class="btn btn-primary w-100" name="run" value="1">Generate</button>
      <button class="btn btn-outline-secondary w-100" onclick="window.print(); return false;">Print</button>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead>
        <?php if ($type==='student'): ?>
          <tr><th>Date</th><th>Subject</th><th>Status</th><th>Remark</th></tr>
        <?php elseif ($type==='class'): ?>
          <tr><th>Date</th><th>Subject</th><th>Present</th><th>Absent</th><th>Leave</th></tr>
        <?php else: ?>
          <tr><th>Roll</th><th>Student</th><th>Present Days</th><th>Absent Days</th><th>Leave Days</th><th>Total</th><th>Present %</th></tr>
        <?php endif; ?>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <?php if ($type==='student'): ?>
            <tr>
              <td><?= e($r['attendance_date']) ?></td>
              <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
              <td><?= e($r['status']) ?></td>
              <td><?= e($r['remark']) ?></td>
            </tr>
          <?php elseif ($type==='class'): ?>
            <tr>
              <td><?= e($r['attendance_date']) ?></td>
              <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
              <td><?= e($r['present_count']) ?></td>
              <td><?= e($r['absent_count']) ?></td>
              <td><?= e($r['leave_count']) ?></td>
            </tr>
          <?php else: ?>
            <tr>
              <td><?= e($r['roll_number']) ?></td>
              <td><?= e($r['student_name']) ?></td>
              <td><?= e($r['present_days']) ?></td>
              <td><?= e($r['absent_days']) ?></td>
              <td><?= e($r['leave_days']) ?></td>
              <td><?= e($r['total']) ?></td>
              <td><?= e($r['present_pct']) ?>%</td>
            </tr>
          <?php endif; ?>
        <?php endforeach; ?>
        <?php if(!$rows && isset($_GET['run'])): ?>
          <tr><td colspan="10" class="text-center text-muted py-4">No data found for selected filters.</td></tr>
        <?php elseif(!isset($_GET['run'])): ?>
          <tr><td colspan="10" class="text-center text-muted py-4">Generate a report using filters above.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
