<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

function setting_get($pdo, $key, $default='') {
  $st = $pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$key]);
  $r = $st->fetch();
  return $r ? $r['value'] : $default;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $institute = trim($_POST['institute_name']);
  $session = trim($_POST['session_year']);
  $edit_days = trim($_POST['edit_days']);
  $cutoff = trim($_POST['cutoff_time']);

  $pdo->prepare("INSERT INTO settings (`key`,value) VALUES ('institute_name',?) ON DUPLICATE KEY UPDATE value=VALUES(value)")->execute([$institute]);
  $pdo->prepare("INSERT INTO settings (`key`,value) VALUES ('session_year',?) ON DUPLICATE KEY UPDATE value=VALUES(value)")->execute([$session]);
  $pdo->prepare("INSERT INTO settings (`key`,value) VALUES ('edit_days',?) ON DUPLICATE KEY UPDATE value=VALUES(value)")->execute([$edit_days]);
  $pdo->prepare("INSERT INTO settings (`key`,value) VALUES ('cutoff_time',?) ON DUPLICATE KEY UPDATE value=VALUES(value)")->execute([$cutoff]);

  flash_set('success','Settings saved.');
  redirect('/admin/settings.php');
}

$institute = setting_get($pdo,'institute_name','Institute');
$session = setting_get($pdo,'session_year','2025-26');
$edit_days = setting_get($pdo,'edit_days','2');
$cutoff = setting_get($pdo,'cutoff_time','10:30');

$page_title = "System Settings | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">System Settings</h3>
  <div class="small-muted">Basic configuration for the institute and attendance rules.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>

<div class="card p-4">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Institute Name</label>
        <input class="form-control" name="institute_name" value="<?= e($institute) ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Session Year</label>
        <input class="form-control" name="session_year" value="<?= e($session) ?>" placeholder="e.g., 2025-26" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Allowed Edit Days (Teacher)</label>
        <input class="form-control" name="edit_days" value="<?= e($edit_days) ?>" type="number" min="0" step="1">
        <div class="small-muted mt-1">Teachers can edit attendance for past dates within this many days.</div>
      </div>
      <div class="col-md-6">
        <label class="form-label">Cutoff Time (Optional)</label>
        <input class="form-control" name="cutoff_time" value="<?= e($cutoff) ?>" type="time">
        <div class="small-muted mt-1">If you enforce late marking rules later, use this value.</div>
      </div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/index.php">Back</a>
    </div>
  </form>

  <hr class="my-4">
  <h6 class="fw-bold">Backup</h6>
  <div class="small-muted">For full database backup, use phpMyAdmin export (.sql). Inside the project, reports provide CSV export.</div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
