<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$sections = $pdo->query("SELECT s.*, c.name as class_name FROM sections s JOIN classes c ON c.id=s.class_id ORDER BY c.name, s.name")->fetchAll();

function student_linked($pdo, $student_id) {
  $st = $pdo->prepare("SELECT COUNT(*) c FROM attendance_entries WHERE student_id=?");
  $st->execute([$student_id]);
  return (int)$st->fetch()['c'] > 0;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'create') {
    $name = trim($_POST['name']);
    $roll = trim($_POST['roll_number']);
    $class_id = (int)$_POST['class_id'];
    $section_id = (int)$_POST['section_id'];
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $pdo->beginTransaction();
    $pdo->prepare("INSERT INTO students (name,roll_number,class_id,section_id,phone,email,address) VALUES (?,?,?,?,?,?,?)")
        ->execute([$name,$roll,$class_id,$section_id,$phone,$email,$address]);
    $sid = (int)$pdo->lastInsertId();
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO users (role, profile_id, name, email, username, password_hash, is_active)
                   VALUES ('student',?,?,?,?,?,1)")
        ->execute([$sid,$name,$email ?: ($username.'@example.com'),$username,$hash]);
    $pdo->commit();
    flash_set('success','Student created.');
    redirect('/admin/students.php');
  }

  if ($act === 'update') {
    $sid = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $roll = trim($_POST['roll_number']);
    $class_id = (int)$_POST['class_id'];
    $section_id = (int)$_POST['section_id'];
    $phone = trim($_POST['phone'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');

    $pdo->beginTransaction();
    $pdo->prepare("UPDATE students SET name=?, roll_number=?, class_id=?, section_id=?, phone=?, email=?, address=? WHERE id=?")
        ->execute([$name,$roll,$class_id,$section_id,$phone,$email,$address,$sid]);
    $pdo->prepare("UPDATE users SET name=?, email=? WHERE role='student' AND profile_id=?")->execute([$name,$email,$sid]);
    $pdo->commit();
    flash_set('success','Student updated.');
    redirect('/admin/students.php');
  }

  if ($act === 'toggle') {
    $uid = (int)$_POST['user_id'];
    $pdo->prepare("UPDATE users SET is_active=1-is_active WHERE id=? AND role='student'")->execute([$uid]);
    flash_set('success','Student account status changed.');
    redirect('/admin/students.php');
  }

  if ($act === 'delete') {
    $sid = (int)$_POST['id'];
    if (student_linked($pdo, $sid)) {
      flash_set('error','Cannot delete student: attendance history exists.');
      redirect('/admin/students.php');
    }
    $pdo->beginTransaction();
    $pdo->prepare("DELETE FROM users WHERE role='student' AND profile_id=?")->execute([$sid]);
    $pdo->prepare("DELETE FROM students WHERE id=?")->execute([$sid]);
    $pdo->commit();
    flash_set('success','Student deleted.');
    redirect('/admin/students.php');
  }
}

$page_title = "Students | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';

$success = flash_get('success');
$error = flash_get('error');

$filter_class = (int)($_GET['class_id'] ?? 0);
$filter_section = (int)($_GET['section_id'] ?? 0);

if ($action === 'edit' && $id) {
  $st = $pdo->prepare("SELECT s.*, u.id as user_id, u.username, u.is_active
                       FROM students s
                       LEFT JOIN users u ON (u.role='student' AND u.profile_id=s.id)
                       WHERE s.id=?");
  $st->execute([$id]);
  $student = $st->fetch();
}
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Student Management</h3>
    <div class="small-muted">Manage student profiles and login accounts.</div>
  </div>
  <a class="btn btn-primary" href="<?= BASE_URL ?>/admin/students.php?action=create">Add Student</a>
</div>

<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<?php if ($action === 'create'): ?>
  <div class="card p-4">
    <h5 class="fw-bold">Add Student</h5>
    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="row g-3">
        <div class="col-md-6"><label class="form-label">Full Name</label><input class="form-control" name="name" required></div>
        <div class="col-md-3"><label class="form-label">Roll No.</label><input class="form-control" name="roll_number" required></div>
        <div class="col-md-3"><label class="form-label">Phone</label><input class="form-control" name="phone"></div>
        <div class="col-md-6"><label class="form-label">Email</label><input class="form-control" type="email" name="email"></div>
        <div class="col-md-3">
          <label class="form-label">Class</label>
          <select class="form-select" name="class_id" required>
            <option value="">Select</option>
            <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Section</label>
          <select class="form-select" name="section_id" required>
            <option value="">Select</option>
            <?php foreach($sections as $s): ?><option value="<?= e($s['id']) ?>"><?= e($s['class_name'].' - '.$s['name']) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-12"><label class="form-label">Address</label><input class="form-control" name="address"></div>

        <div class="col-md-6"><label class="form-label">Login Username</label><input class="form-control" name="username" required></div>
        <div class="col-md-6"><label class="form-label">Login Password</label><input class="form-control" type="password" name="password" required></div>
      </div>
      <div class="mt-3 d-flex gap-2">
        <button class="btn btn-primary px-4">Create</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/students.php">Cancel</a>
      </div>
    </form>
  </div>

<?php elseif ($action === 'edit' && !empty($student)): ?>
  <div class="card p-4">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h5 class="fw-bold mb-0">Edit Student</h5>
        <div class="small-muted">Username: <b><?= e($student['username'] ?? '-') ?></b></div>
      </div>
      <form method="post" onsubmit="return confirm('Change active status?');">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="toggle">
        <input type="hidden" name="user_id" value="<?= e($student['user_id']) ?>">
        <button class="btn btn-outline-<?= ((int)$student['is_active']===1)?'danger':'success' ?>">
          <?= ((int)$student['is_active']===1)?'Deactivate':'Activate' ?>
        </button>
      </form>
    </div>

    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="id" value="<?= e($student['id']) ?>">
      <div class="row g-3">
        <div class="col-md-6"><label class="form-label">Full Name</label><input class="form-control" name="name" required value="<?= e($student['name']) ?>"></div>
        <div class="col-md-3"><label class="form-label">Roll No.</label><input class="form-control" name="roll_number" required value="<?= e($student['roll_number']) ?>"></div>
        <div class="col-md-3"><label class="form-label">Phone</label><input class="form-control" name="phone" value="<?= e($student['phone']) ?>"></div>
        <div class="col-md-6"><label class="form-label">Email</label><input class="form-control" type="email" name="email" value="<?= e($student['email']) ?>"></div>
        <div class="col-md-3">
          <label class="form-label">Class</label>
          <select class="form-select" name="class_id" required>
            <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>" <?= ((int)$c['id']===(int)$student['class_id'])?'selected':'' ?>><?= e($c['name']) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Section</label>
          <select class="form-select" name="section_id" required>
            <?php foreach($sections as $s): ?><option value="<?= e($s['id']) ?>" <?= ((int)$s['id']===(int)$student['section_id'])?'selected':'' ?>><?= e($s['class_name'].' - '.$s['name']) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-12"><label class="form-label">Address</label><input class="form-control" name="address" value="<?= e($student['address']) ?>"></div>
      </div>
      <div class="mt-3 d-flex gap-2">
        <button class="btn btn-primary px-4">Save</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/students.php">Back</a>
      </div>
    </form>

    <hr class="my-4">
    <form method="post" onsubmit="return confirm('Delete student?');">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="id" value="<?= e($student['id']) ?>">
      <button class="btn btn-danger">Delete Student</button>
      <?php if (student_linked($pdo, $student['id'])): ?>
        <div class="small text-danger mt-2">Warning: Attendance history exists. Delete is blocked.</div>
      <?php endif; ?>
    </form>
  </div>

<?php else: 
  $sql = "SELECT s.*, c.name as class_name, sec.name as section_name, u.username, u.is_active
          FROM students s
          JOIN classes c ON c.id=s.class_id
          JOIN sections sec ON sec.id=s.section_id
          LEFT JOIN users u ON (u.role='student' AND u.profile_id=s.id)
          WHERE 1=1";
  $params = [];
  if ($filter_class) { $sql .= " AND s.class_id=?"; $params[]=$filter_class; }
  if ($filter_section) { $sql .= " AND s.section_id=?"; $params[]=$filter_section; }
  $sql .= " ORDER BY s.id DESC";
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $rows = $st->fetchAll();
?>
  <div class="card p-3">
    <form class="row g-2 p-2" method="get">
      <div class="col-md-4">
        <select class="form-select" name="class_id">
          <option value="0">All Classes</option>
          <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>" <?= ($filter_class===(int)$c['id'])?'selected':'' ?>><?= e($c['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <select class="form-select" name="section_id">
          <option value="0">All Sections</option>
          <?php foreach($sections as $s): ?><option value="<?= e($s['id']) ?>" <?= ($filter_section===(int)$s['id'])?'selected':'' ?>><?= e($s['class_name'].' - '.$s['name']) ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4 d-flex gap-2">
        <button class="btn btn-outline-primary w-100">Filter</button>
        <a class="btn btn-outline-secondary w-100" href="<?= BASE_URL ?>/admin/students.php">Reset</a>
      </div>
    </form>
    <div class="table-responsive mt-2">
      <table class="table align-middle">
        <thead><tr>
          <th>Name</th><th>Roll</th><th>Class</th><th>Section</th><th>Username</th><th>Status</th><th class="text-end">Action</th>
        </tr></thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?= e($r['name']) ?></td>
              <td><?= e($r['roll_number']) ?></td>
              <td><?= e($r['class_name']) ?></td>
              <td><?= e($r['section_name']) ?></td>
              <td><?= e($r['username'] ?? '-') ?></td>
              <td><?= ((int)$r['is_active']===1)?'<span class="badge text-bg-success">Active</span>':'<span class="badge text-bg-secondary">Inactive</span>' ?></td>
              <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/admin/students.php?action=edit&id=<?= e($r['id']) ?>">Manage</a></td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="7" class="text-center text-muted py-4">No students found.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
