<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$classes = $pdo->query("SELECT * FROM classes ORDER BY name")->fetchAll();
$sections = $pdo->query("SELECT s.*, c.name as class_name FROM sections s JOIN classes c ON c.id=s.class_id ORDER BY c.name, s.name")->fetchAll();
$subjects = $pdo->query("SELECT * FROM subjects ORDER BY name")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $act = $_POST['action'] ?? '';
  if ($act === 'add_subject') {
    $name = trim($_POST['name']);
    $code = trim($_POST['code']);
    try {
      $pdo->prepare("INSERT INTO subjects (name,code) VALUES (?,?)")->execute([$name,$code]);
      flash_set('success','Subject added.');
    } catch(Exception $e) {
      flash_set('error','Subject code already exists.');
    }
    redirect('/admin/subjects.php');
  }
  if ($act === 'delete_subject') {
    $id = (int)$_POST['id'];
    $c = $pdo->prepare("SELECT COUNT(*) c FROM allocations WHERE subject_id=?");
    $c->execute([$id]);
    if ((int)$c->fetch()['c']>0) { flash_set('error','Cannot delete: subject is allocated.'); redirect('/admin/subjects.php'); }
    $pdo->prepare("DELETE FROM subjects WHERE id=?")->execute([$id]);
    flash_set('success','Subject deleted.');
    redirect('/admin/subjects.php');
  }
  if ($act === 'assign_subject') {
    $subject_id = (int)$_POST['subject_id'];
    $class_id = (int)$_POST['class_id'];
    $section_id = (int)$_POST['section_id'];
    try {
      $pdo->prepare("INSERT INTO subject_assignments (subject_id,class_id,section_id) VALUES (?,?,?)")
          ->execute([$subject_id,$class_id,$section_id]);
      flash_set('success','Subject assigned to class/section.');
    } catch(Exception $e) {
      flash_set('error','This subject is already assigned to this class/section.');
    }
    redirect('/admin/subjects.php');
  }
  if ($act === 'remove_assignment') {
    $aid = (int)$_POST['id'];
    $pdo->prepare("DELETE FROM subject_assignments WHERE id=?")->execute([$aid]);
    flash_set('success','Assignment removed.');
    redirect('/admin/subjects.php');
  }
}

$assignments = $pdo->query("SELECT sa.id, sub.name as subject_name, sub.code, c.name as class_name, sec.name as section_name
                            FROM subject_assignments sa
                            JOIN subjects sub ON sub.id=sa.subject_id
                            JOIN classes c ON c.id=sa.class_id
                            JOIN sections sec ON sec.id=sa.section_id
                            ORDER BY c.name, sec.name, sub.name")->fetchAll();

$page_title = "Subjects | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';

$success = flash_get('success');
$error = flash_get('error');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Subject Management</h3>
  <div class="small-muted">Add subjects and assign them to classes/sections.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-4">
      <h5 class="fw-bold">Add Subject</h5>
      <form method="post" class="mt-2">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="add_subject">
        <div class="mb-2">
          <label class="form-label">Subject Name</label>
          <input class="form-control" name="name" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Subject Code</label>
          <input class="form-control" name="code" required>
        </div>
        <button class="btn btn-primary">Add</button>
      </form>

      <hr class="my-4">
      <h6 class="fw-bold">Subjects</h6>
      <?php foreach($subjects as $s): ?>
        <div class="d-flex justify-content-between align-items-center border rounded-4 p-3 mb-2">
          <div>
            <div class="fw-semibold"><?= e($s['name']) ?></div>
            <div class="small-muted"><?= e($s['code']) ?></div>
          </div>
          <form method="post" onsubmit="return confirm('Delete subject?');">
            <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
            <input type="hidden" name="action" value="delete_subject">
            <input type="hidden" name="id" value="<?= e($s['id']) ?>">
            <button class="btn btn-sm btn-outline-danger">Delete</button>
          </form>
        </div>
      <?php endforeach; ?>
      <?php if(!$subjects): ?><div class="text-muted">No subjects yet.</div><?php endif; ?>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-4">
      <h5 class="fw-bold">Assign Subject to Class/Section</h5>
      <form method="post" class="mt-2">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="assign_subject">
        <div class="row g-2">
          <div class="col-md-4">
            <select class="form-select" name="subject_id" required>
              <option value="">Subject</option>
              <?php foreach($subjects as $s): ?><option value="<?= e($s['id']) ?>"><?= e($s['code'].' - '.$s['name']) ?></option><?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-4">
            <select class="form-select" name="class_id" required>
              <option value="">Class</option>
              <?php foreach($classes as $c): ?><option value="<?= e($c['id']) ?>"><?= e($c['name']) ?></option><?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-4">
            <div class="input-group">
              <select class="form-select" name="section_id" required>
                <option value="">Section</option>
                <?php foreach($sections as $sec): ?><option value="<?= e($sec['id']) ?>"><?= e($sec['class_name'].' - '.$sec['name']) ?></option><?php endforeach; ?>
              </select>
              <button class="btn btn-primary">Assign</button>
            </div>
          </div>
        </div>
      </form>

      <hr class="my-4">
      <h6 class="fw-bold">Assignments</h6>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Class</th><th>Section</th><th>Subject</th><th class="text-end">Action</th></tr></thead>
          <tbody>
            <?php foreach($assignments as $a): ?>
              <tr>
                <td><?= e($a['class_name']) ?></td>
                <td><?= e($a['section_name']) ?></td>
                <td><?= e($a['code'].' - '.$a['subject_name']) ?></td>
                <td class="text-end">
                  <form method="post" onsubmit="return confirm('Remove assignment?');">
                    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="remove_assignment">
                    <input type="hidden" name="id" value="<?= e($a['id']) ?>">
                    <button class="btn btn-sm btn-outline-danger">Remove</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$assignments): ?><tr><td colspan="4" class="text-center text-muted py-4">No assignments yet.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
