<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('admin');
csrf_verify();
$pdo = db();

$action = $_GET['action'] ?? 'list';
$id = (int)($_GET['id'] ?? 0);

function teacher_linked($pdo, $teacher_id) {
  $st = $pdo->prepare("SELECT COUNT(*) c FROM allocations WHERE teacher_id=?");
  $st->execute([$teacher_id]);
  return (int)$st->fetch()['c'] > 0;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $postAction = $_POST['action'] ?? '';
  if ($postAction === 'create') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $designation = trim($_POST['designation'] ?? '');
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $pdo->beginTransaction();
    $st = $pdo->prepare("INSERT INTO teachers (name,email,phone,address,designation) VALUES (?,?,?,?,?)");
    $st->execute([$name,$email,$phone,$address,$designation]);
    $teacher_id = (int)$pdo->lastInsertId();

    $hash = password_hash($password, PASSWORD_DEFAULT);
    $u = $pdo->prepare("INSERT INTO users (role, profile_id, name, email, username, password_hash, is_active)
                        VALUES ('teacher',?,?,?,?,?,1)");
    $u->execute([$teacher_id,$name,$email,$username,$hash]);
    $pdo->commit();

    flash_set('success', 'Teacher created successfully.');
    redirect('/admin/teachers.php');
  }

  if ($postAction === 'update') {
    $tid = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone'] ?? '');
    $address = trim($_POST['address'] ?? '');
    $designation = trim($_POST['designation'] ?? '');

    $pdo->beginTransaction();
    $st = $pdo->prepare("UPDATE teachers SET name=?, email=?, phone=?, address=?, designation=? WHERE id=?");
    $st->execute([$name,$email,$phone,$address,$designation,$tid]);
    $u = $pdo->prepare("UPDATE users SET name=?, email=? WHERE role='teacher' AND profile_id=?");
    $u->execute([$name,$email,$tid]);
    $pdo->commit();

    flash_set('success', 'Teacher updated.');
    redirect('/admin/teachers.php');
  }

  if ($postAction === 'toggle') {
    $uid = (int)$_POST['user_id'];
    $st = $pdo->prepare("UPDATE users SET is_active = 1 - is_active WHERE id=? AND role='teacher'");
    $st->execute([$uid]);
    flash_set('success', 'Teacher account status changed.');
    redirect('/admin/teachers.php');
  }

  if ($postAction === 'delete') {
    $tid = (int)$_POST['id'];
    if (teacher_linked($pdo, $tid)) {
      flash_set('error', 'Cannot delete teacher: linked to allocations.');
      redirect('/admin/teachers.php');
    }
    $pdo->beginTransaction();
    $pdo->prepare("DELETE FROM users WHERE role='teacher' AND profile_id=?")->execute([$tid]);
    $pdo->prepare("DELETE FROM teachers WHERE id=?")->execute([$tid]);
    $pdo->commit();
    flash_set('success', 'Teacher deleted.');
    redirect('/admin/teachers.php');
  }
}

$page_title = "Teachers | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';

$success = flash_get('success');
$error = flash_get('error');

if ($action === 'edit' && $id) {
  $st = $pdo->prepare("SELECT t.*, u.id as user_id, u.username, u.is_active
                       FROM teachers t
                       LEFT JOIN users u ON (u.role='teacher' AND u.profile_id=t.id)
                       WHERE t.id=?");
  $st->execute([$id]);
  $teacher = $st->fetch();
  if (!$teacher) { echo "<div class='alert alert-danger'>Teacher not found.</div>"; $action='list'; }
}
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Teacher Management</h3>
    <div class="small-muted">Create, update, activate/deactivate and delete teacher accounts.</div>
  </div>
  <a class="btn btn-primary" href="<?= BASE_URL ?>/admin/teachers.php?action=create">Add Teacher</a>
</div>

<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<?php if ($action === 'create'): ?>
  <div class="card p-4">
    <h5 class="fw-bold">Add Teacher</h5>
    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="create">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Full Name</label>
          <input class="form-control" name="name" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input class="form-control" type="email" name="email" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Phone</label>
          <input class="form-control" name="phone">
        </div>
        <div class="col-md-4">
          <label class="form-label">Designation</label>
          <input class="form-control" name="designation" placeholder="e.g., Lecturer">
        </div>
        <div class="col-md-4">
          <label class="form-label">Address</label>
          <input class="form-control" name="address">
        </div>
        <div class="col-md-6">
          <label class="form-label">Login Username</label>
          <input class="form-control" name="username" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Login Password</label>
          <input class="form-control" type="password" name="password" required>
        </div>
      </div>
      <div class="mt-3 d-flex gap-2">
        <button class="btn btn-primary px-4">Create</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/teachers.php">Cancel</a>
      </div>
    </form>
  </div>

<?php elseif ($action === 'edit' && !empty($teacher)): ?>
  <div class="card p-4">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h5 class="fw-bold mb-0">Edit Teacher</h5>
        <div class="small-muted">Username: <b><?= e($teacher['username'] ?? '-') ?></b></div>
      </div>
      <form method="post" onsubmit="return confirm('Change active status?');">
        <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="action" value="toggle">
        <input type="hidden" name="user_id" value="<?= e($teacher['user_id']) ?>">
        <button class="btn btn-outline-<?= ((int)$teacher['is_active']===1)?'danger':'success' ?>">
          <?= ((int)$teacher['is_active']===1)?'Deactivate':'Activate' ?>
        </button>
      </form>
    </div>

    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="id" value="<?= e($teacher['id']) ?>">
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Full Name</label>
          <input class="form-control" name="name" required value="<?= e($teacher['name']) ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input class="form-control" type="email" name="email" required value="<?= e($teacher['email']) ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Phone</label>
          <input class="form-control" name="phone" value="<?= e($teacher['phone']) ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Designation</label>
          <input class="form-control" name="designation" value="<?= e($teacher['designation']) ?>">
        </div>
        <div class="col-md-4">
          <label class="form-label">Address</label>
          <input class="form-control" name="address" value="<?= e($teacher['address']) ?>">
        </div>
      </div>
      <div class="mt-3 d-flex gap-2">
        <button class="btn btn-primary px-4">Save</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/admin/teachers.php">Back</a>
      </div>
    </form>

    <hr class="my-4">
    <form method="post" onsubmit="return confirm('Delete teacher? This cannot be undone.');">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="id" value="<?= e($teacher['id']) ?>">
      <button class="btn btn-danger">Delete Teacher</button>
      <?php if (teacher_linked($pdo, $teacher['id'])): ?>
        <div class="small text-danger mt-2">Warning: This teacher has allocations. Delete is blocked until allocations are removed.</div>
      <?php endif; ?>
    </form>
  </div>

<?php else: 
  $rows = $pdo->query("SELECT t.*, u.id as user_id, u.username, u.is_active
                       FROM teachers t
                       LEFT JOIN users u ON (u.role='teacher' AND u.profile_id=t.id)
                       ORDER BY t.id DESC")->fetchAll();
?>
  <div class="card p-3">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Name</th>
            <th>Username</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Designation</th>
            <th>Status</th>
            <th class="text-end">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?= e($r['name']) ?></td>
              <td><?= e($r['username'] ?? '-') ?></td>
              <td><?= e($r['email']) ?></td>
              <td><?= e($r['phone']) ?></td>
              <td><?= e($r['designation']) ?></td>
              <td>
                <?php if ((int)$r['is_active']===1): ?>
                  <span class="badge text-bg-success">Active</span>
                <?php else: ?>
                  <span class="badge text-bg-secondary">Inactive</span>
                <?php endif; ?>
              </td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/admin/teachers.php?action=edit&id=<?= e($r['id']) ?>">Manage</a>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?><tr><td colspan="7" class="text-center text-muted py-4">No teachers found.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
