<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/auth.php';
csrf_verify();

if (is_logged_in()) {
  $u = current_user();
  if ($u['role'] === 'admin') redirect('/admin/index.php');
  if ($u['role'] === 'teacher') redirect('/teacher/index.php');
  if ($u['role'] === 'student') redirect('/student/index.php');
}

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $password = $_POST['password'] ?? '';
  [$ok, $msg] = login_attempt($username, $password);
  if ($ok) {
    $u = current_user();
    if ($u['role'] === 'admin') redirect('/admin/index.php');
    if ($u['role'] === 'teacher') redirect('/teacher/index.php');
    if ($u['role'] === 'student') redirect('/student/index.php');
  } else {
    $error = $msg;
  }
}

$page_title = "Login | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
?>
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-5">
      <div class="card p-4">
        <div class="d-flex align-items-center justify-content-between">
          <div>
            <h4 class="fw-bold mb-1">Sign In</h4>
            <div class="small-muted">Access your dashboard securely.</div>
          </div>
          <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/index.php">Home</a>
        </div>

        <?php if ($error): ?>
          <div class="alert alert-danger mt-3" data-auto-dismiss="1"><?= e($error) ?></div>
        <?php endif; ?>

        <?php if ($msg = flash_get('success')): ?>
          <div class="alert alert-success mt-3" data-auto-dismiss="1"><?= e($msg) ?></div>
        <?php endif; ?>

        <form method="post" class="mt-3">
          <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
          <div class="mb-3">
            <label class="form-label">Username or Email</label>
            <input class="form-control" name="username" required placeholder="e.g. admin">
          </div>
          <div class="mb-3">
            <label class="form-label">Password</label>
            <input class="form-control" type="password" name="password" required placeholder="••••••••">
          </div>
          <button class="btn btn-primary w-100 py-2">Login</button>

          <div class="small text-center mt-3 text-muted">
            Demo: admin/Admin@123 • tanuj/Teacher@123 • stu001/Student@123
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../includes/layout_foot.php'; ?>
