<?php
require_once __DIR__ . '/../includes/helpers.php';
require_once __DIR__ . '/../config/db.php';
require_login();
csrf_verify();
$pdo = db();
$user = current_user();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $current = $_POST['current_password'] ?? '';
  $new = $_POST['new_password'] ?? '';
  $confirm = $_POST['confirm_password'] ?? '';
  if ($new !== $confirm) {
    flash_set('error','New passwords do not match.');
    redirect('/change_password.php');
  }
  $st = $pdo->prepare("SELECT password_hash FROM users WHERE id=?");
  $st->execute([(int)$user['id']]);
  $hash = $st->fetch()['password_hash'] ?? '';
  if (!password_verify($current, $hash)) {
    flash_set('error','Current password is incorrect.');
    redirect('/change_password.php');
  }
  $newHash = password_hash($new, PASSWORD_DEFAULT);
  $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$newHash,(int)$user['id']]);
  flash_set('success','Password changed successfully.');
  redirect('/change_password.php');
}

$page_title = "Change Password | " . APP_NAME;
include __DIR__ . '/../includes/layout_head.php';
include __DIR__ . '/../includes/dashboard_shell.php';

$success = flash_get('success');
$error = flash_get('error');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Change Password</h3>
  <div class="small-muted">Update your account password securely.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="card p-4" style="max-width:720px;">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="mb-3">
      <label class="form-label">Current Password</label>
      <input type="password" class="form-control" name="current_password" required>
    </div>
    <div class="mb-3">
      <label class="form-label">New Password</label>
      <input type="password" class="form-control" name="new_password" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Confirm New Password</label>
      <input type="password" class="form-control" name="confirm_password" required>
    </div>
    <button class="btn btn-primary">Save</button>
  </form>
</div>

<?php
include __DIR__ . '/../includes/dashboard_shell_end.php';
include __DIR__ . '/../includes/layout_foot.php';
?>
