<?php
require_once __DIR__ . '/../includes/helpers.php';
$page_title = APP_NAME . ' | Smart Attendance';
include __DIR__ . '/../includes/layout_head.php';
?>
<section class="hero py-5">
  <div class="container py-4">
    <div class="row align-items-center g-4">
      <div class="col-lg-6">
        <span class="badge badge-soft rounded-pill px-3 py-2">PHP + MySQL • Role Based</span>
        <h1 class="display-5 mt-3 fw-bold">Professional Online Attendance System</h1>
        <p class="lead text-white-50">
          Manage classes, subjects, teachers, students, leave requests, notices, and attendance—cleanly and securely.
          Built for real institutional workflows.
        </p>
        <div class="d-flex gap-2 flex-wrap">
          <a class="btn btn-primary btn-lg" href="<?= BASE_URL ?>/auth/login.php">Login</a>
          <a class="btn btn-outline-light btn-lg" href="#features">Explore Features</a>
        </div>
        <div class="mt-4 d-flex gap-2 flex-wrap">
          <span class="badge badge-soft rounded-pill">CSV Reports</span>
          <span class="badge badge-soft rounded-pill">Attendance Lock</span>
          <span class="badge badge-soft rounded-pill">Edit Reason Tracking</span>
          <span class="badge badge-soft rounded-pill">Notices & Leaves</span>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="card p-4">
          <h5 class="fw-bold mb-3">Quick Demo Access</h5>
          <div class="row g-3">
            <div class="col-md-4">
              <div class="p-3 rounded-4 border">
                <div class="fw-semibold">Admin</div>
                <div class="small-muted">admin / Admin@123</div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="p-3 rounded-4 border">
                <div class="fw-semibold">Teacher</div>
                <div class="small-muted">tanuj / Teacher@123</div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="p-3 rounded-4 border">
                <div class="fw-semibold">Student</div>
                <div class="small-muted">stu001 / Student@123</div>
              </div>
            </div>
          </div>
          <hr class="my-4">
          <div class="d-flex align-items-center justify-content-between">
            <div>
              <div class="fw-semibold">Built for a business-grade UI</div>
              <div class="small-muted">Responsive sidebar dashboards and clean tables.</div>
            </div>
            <a class="btn btn-success" href="<?= BASE_URL ?>/auth/login.php">Continue</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="features" class="py-5">
  <div class="container">
    <div class="row g-4">
      <div class="col-lg-4">
        <div class="card p-4 h-100">
          <h5 class="fw-bold">Admin Suite</h5>
          <p class="small-muted">Teacher/Student CRUD, Class/Section, Subjects, Allocations, Attendance controls, Reports, Settings.</p>
          <ul class="small">
            <li>Attendance lock & edit audit</li>
            <li>Notice & leave workflow</li>
            <li>CSV exports</li>
          </ul>
        </div>
      </div>
      <div class="col-lg-4">
        <div class="card p-4 h-100">
          <h5 class="fw-bold">Teacher Tools</h5>
          <p class="small-muted">Mark attendance per class/subject/date, prevent duplicates, view history, export reports.</p>
          <ul class="small">
            <li>Allowed edit window</li>
            <li>Student search (assigned classes)</li>
            <li>Subject-wise summaries</li>
          </ul>
        </div>
      </div>
      <div class="col-lg-4">
        <div class="card p-4 h-100">
          <h5 class="fw-bold">Student Portal</h5>
          <p class="small-muted">View attendance, monthly overview, percentages, notices, and leave requests.</p>
          <ul class="small">
            <li>Self CSV download</li>
            <li>Leave status tracking</li>
            <li>Profile updates</li>
          </ul>
        </div>
      </div>
    </div>

    <div class="mt-5 text-center">
      <div class="small-muted">© <?= date('Y') ?> <?= e(APP_NAME) ?> — Built with PHP & MySQL</div>
    </div>
  </div>
</section>
<?php include __DIR__ . '/../includes/layout_foot.php'; ?>
