<?php
require_once __DIR__ . '/../includes/helpers.php';
require_once __DIR__ . '/../config/db.php';
require_login();
csrf_verify();

$pdo = db();
$u = current_user();
$role = $u['role'];

$success = null;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');
  $address = trim($_POST['address'] ?? '');

  // Update base user
  $stmt = $pdo->prepare("UPDATE users SET name=?, email=? WHERE id=?");
  $stmt->execute([$name, $email, $u['id']]);

  // Update role profile table
  if ($role === 'admin') {
    $stmt = $pdo->prepare("UPDATE admins SET phone=? WHERE id=?");
    $stmt->execute([$phone, $u['profile_id']]);
  } elseif ($role === 'teacher') {
    $stmt = $pdo->prepare("UPDATE teachers SET phone=?, address=? WHERE id=?");
    $stmt->execute([$phone, $address, $u['profile_id']]);
  } else {
    $stmt = $pdo->prepare("UPDATE students SET phone=?, email=?, address=? WHERE id=?");
    $stmt->execute([$phone, $email, $address, $u['profile_id']]);
  }

  // refresh session
  start_app_session();
  $_SESSION['user']['name'] = $name;
  $_SESSION['user']['email'] = $email;

  $success = "Profile updated.";
}

// load current profile data
$phone = '';
$address = '';
if ($role === 'admin') {
  $st = $pdo->prepare("SELECT phone FROM admins WHERE id=?");
  $st->execute([$u['profile_id']]);
  $row = $st->fetch();
  $phone = $row['phone'] ?? '';
} elseif ($role === 'teacher') {
  $st = $pdo->prepare("SELECT phone, address FROM teachers WHERE id=?");
  $st->execute([$u['profile_id']]);
  $row = $st->fetch();
  $phone = $row['phone'] ?? '';
  $address = $row['address'] ?? '';
} else {
  $st = $pdo->prepare("SELECT phone, address FROM students WHERE id=?");
  $st->execute([$u['profile_id']]);
  $row = $st->fetch();
  $phone = $row['phone'] ?? '';
  $address = $row['address'] ?? '';
}

$page_title = "Profile | " . APP_NAME;
include __DIR__ . '/../includes/layout_head.php';
include __DIR__ . '/../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">My Profile</h3>
    <div class="small-muted">Update your personal details.</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/change_password.php">Change Password</a>
</div>

<?php if ($success): ?>
  <div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div>
<?php endif; ?>
<?php if ($error): ?>
  <div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div>
<?php endif; ?>

<div class="card p-4">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Full Name</label>
        <input class="form-control" name="name" required value="<?= e($u['name']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Email</label>
        <input class="form-control" type="email" name="email" required value="<?= e($u['email']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Phone</label>
        <input class="form-control" name="phone" value="<?= e($phone) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Role</label>
        <input class="form-control" value="<?= e(ucfirst($role)) ?>" disabled>
      </div>
      <div class="col-12">
        <label class="form-label">Address (optional)</label>
        <textarea class="form-control" name="address" rows="2"><?= e($address) ?></textarea>
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary px-4">Save Changes</button>
    </div>
  </form>
</div>
<?php
include __DIR__ . '/../includes/dashboard_shell_end.php';
include __DIR__ . '/../includes/layout_foot.php';
?>
