<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/reporting.php';
require_once __DIR__ . '/../../config/db.php';
require_login('student');
csrf_verify();
$pdo = db();
$user = current_user();
$student_id = (int)$user['profile_id'];

$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? now_date();
$export = (int)($_GET['export'] ?? 0);

$rows = [];
if (isset($_GET['run'])) {
  $st = $pdo->prepare("SELECT ses.attendance_date, sub.code, sub.name as subject_name, ae.status, ae.remark
                       FROM attendance_entries ae
                       JOIN attendance_sessions ses ON ses.id=ae.session_id
                       JOIN subjects sub ON sub.id=ses.subject_id
                       WHERE ae.student_id=? AND ses.attendance_date BETWEEN ? AND ?
                       ORDER BY ses.attendance_date, sub.code");
  $st->execute([$student_id,$from,$to]);
  $rows = $st->fetchAll();

  if ($export) {
    csv_download("my_attendance.csv", ["Date","Subject Code","Subject","Status","Remark"],
      array_map(fn($r)=>[$r['attendance_date'],$r['code'],$r['subject_name'],$r['status'],$r['remark']], $rows));
  }
}

// Subject-wise percentage
$subPct = $pdo->prepare("SELECT sub.code, sub.name,
                         SUM(ae.status='present') present_days,
                         COUNT(*) total_days,
                         ROUND((SUM(ae.status='present')/COUNT(*))*100,2) present_pct
                         FROM attendance_entries ae
                         JOIN attendance_sessions ses ON ses.id=ae.session_id
                         JOIN subjects sub ON sub.id=ses.subject_id
                         WHERE ae.student_id=? AND ses.attendance_date BETWEEN ? AND ?
                         GROUP BY sub.id
                         ORDER BY sub.code");
$subPct->execute([$student_id,$from,$to]);
$pctRows = $subPct->fetchAll();

$page_title = "My Attendance | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Attendance View</h3>
  <div class="small-muted">Monthly view, subject-wise percentage, and CSV download.</div>
</div>

<div class="card p-4 mb-3">
  <form method="get" class="row g-2">
    <div class="col-md-4">
      <label class="form-label">From</label>
      <input type="date" class="form-control" name="from" value="<?= e($from) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">To</label>
      <input type="date" class="form-control" name="to" value="<?= e($to) ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">CSV Export</label>
      <select class="form-select" name="export">
        <option value="0">No</option>
        <option value="1">Yes (Download)</option>
      </select>
    </div>
    <div class="col-12 d-flex gap-2">
      <button class="btn btn-primary w-100" name="run" value="1">Load</button>
      <button class="btn btn-outline-secondary w-100" onclick="window.print(); return false;">Print</button>
    </div>
  </form>
</div>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="card p-3">
      <h6 class="fw-bold mb-2">Subject-wise Percentage</h6>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Subject</th><th>Present/Total</th><th>Present %</th></tr></thead>
          <tbody>
            <?php foreach($pctRows as $r): ?>
              <tr>
                <td><?= e($r['code'].' - '.$r['name']) ?></td>
                <td><?= e($r['present_days'].'/'.$r['total_days']) ?></td>
                <td><?= e($r['present_pct']) ?>%</td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$pctRows): ?><tr><td colspan="3" class="text-center text-muted py-4">No data in selected range.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="card p-3">
      <h6 class="fw-bold mb-2">Date-wise Attendance</h6>
      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Date</th><th>Subject</th><th>Status</th><th>Remark</th></tr></thead>
          <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?= e($r['attendance_date']) ?></td>
                <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
                <td><?= e($r['status']) ?></td>
                <td><?= e($r['remark']) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$rows && isset($_GET['run'])): ?><tr><td colspan="4" class="text-center text-muted py-4">No entries found.</td></tr>
            <?php elseif(!isset($_GET['run'])): ?><tr><td colspan="4" class="text-center text-muted py-4">Load attendance using the filters above.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
