<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('student');
$pdo = db();
$user = current_user();
$student_id = (int)$user['profile_id'];

$student = $pdo->prepare("SELECT s.*, c.name as class_name, sec.name as section_name FROM students s
                          JOIN classes c ON c.id=s.class_id
                          JOIN sections sec ON sec.id=s.section_id
                          WHERE s.id=?");
$student->execute([$student_id]);
$stProfile = $student->fetch();

$today = now_date();

$todayRows = $pdo->prepare("SELECT sub.code, sub.name as subject_name, ae.status
                            FROM attendance_entries ae
                            JOIN attendance_sessions ses ON ses.id=ae.session_id
                            JOIN subjects sub ON sub.id=ses.subject_id
                            WHERE ae.student_id=? AND ses.attendance_date=?
                            ORDER BY sub.code");
$todayRows->execute([$student_id,$today]);
$todayAtt = $todayRows->fetchAll();

$subjectList = $pdo->prepare("SELECT DISTINCT sub.id, sub.code, sub.name
                              FROM subject_assignments sa
                              JOIN subjects sub ON sub.id=sa.subject_id
                              WHERE sa.class_id=? AND sa.section_id=?
                              ORDER BY sub.code");
$subjectList->execute([(int)$stProfile['class_id'],(int)$stProfile['section_id']]);
$subjects = $subjectList->fetchAll();

$page_title = "Student Dashboard | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Student Dashboard</h3>
    <div class="small-muted"><?= e($stProfile['class_name'].' - '.$stProfile['section_name']) ?> • Roll: <?= e($stProfile['roll_number']) ?></div>
  </div>
  <a class="btn btn-primary" href="<?= BASE_URL ?>/student/attendance.php">View Attendance</a>
</div>

<div class="row g-3">
  <div class="col-lg-6">
    <div class="card p-4">
      <h5 class="fw-bold mb-1">Today's Attendance</h5>
      <div class="small-muted">Date: <?= e(today_dmy()) ?></div>
      <div class="mt-3">
        <?php if ($todayAtt): ?>
          <div class="table-responsive">
            <table class="table align-middle">
              <thead><tr><th>Subject</th><th>Status</th></tr></thead>
              <tbody>
                <?php foreach($todayAtt as $r): ?>
                  <tr>
                    <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
                    <td><?= e($r['status']) ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php else: ?>
          <div class="alert alert-info mb-0">No attendance marked yet for today.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-lg-6">
    <div class="card p-4">
      <h5 class="fw-bold mb-1">My Subjects</h5>
      <div class="small-muted">Subjects configured for your class/section.</div>
      <div class="mt-3">
        <?php if ($subjects): ?>
          <ul class="list-group">
            <?php foreach($subjects as $s): ?>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <span><?= e($s['code'].' - '.$s['name']) ?></span>
                <span class="badge text-bg-light">Active</span>
              </li>
            <?php endforeach; ?>
          </ul>
        <?php else: ?>
          <div class="text-muted">No subjects assigned yet.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
