<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('student');
csrf_verify();
$pdo = db();
$user = current_user();
$student_id = (int)$user['profile_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $date_from = $_POST['date_from'];
  $date_to = $_POST['date_to'];
  $reason = trim($_POST['reason']);
  $pdo->prepare("INSERT INTO leave_requests (student_id, date_from, date_to, reason, status) VALUES (?,?,?,?, 'pending')")
      ->execute([$student_id,$date_from,$date_to,$reason]);
  flash_set('success','Leave request submitted.');
  redirect('/student/leaves.php');
}

$rows = $pdo->prepare("SELECT * FROM leave_requests WHERE student_id=? ORDER BY created_at DESC");
$rows->execute([$student_id]);
$my = $rows->fetchAll();

$page_title = "Leave Requests | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Leave Request</h3>
  <div class="small-muted">Apply for leave and track status.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>

<div class="card p-4 mb-3" style="max-width:860px;">
  <h5 class="fw-bold">Apply Leave</h5>
  <form method="post" class="mt-2">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-2">
      <div class="col-md-3">
        <label class="form-label">From</label>
        <input type="date" class="form-control" name="date_from" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">To</label>
        <input type="date" class="form-control" name="date_to" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Reason</label>
        <input class="form-control" name="reason" required>
      </div>
    </div>
    <button class="btn btn-primary mt-2">Submit</button>
  </form>
</div>

<div class="card p-3">
  <h6 class="fw-bold px-2 pt-2">My Leave History</h6>
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>From</th><th>To</th><th>Reason</th><th>Status</th><th>Remarks</th></tr></thead>
      <tbody>
        <?php foreach($my as $r): ?>
          <tr>
            <td><?= e($r['date_from']) ?></td>
            <td><?= e($r['date_to']) ?></td>
            <td><?= e($r['reason']) ?></td>
            <td><?= e($r['status']) ?></td>
            <td><?= e($r['remarks']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$my): ?><tr><td colspan="5" class="text-center text-muted py-4">No leave requests yet.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
