<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('student');
$pdo = db();

$rows = $pdo->query("SELECT * FROM notices WHERE is_active=1 AND (target_role='all' OR target_role='student') ORDER BY created_at DESC")->fetchAll();

$page_title = "Notices | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Notices</h3>
  <div class="small-muted">Announcements and updates from the institute.</div>
</div>

<div class="row g-3">
  <?php foreach($rows as $n): ?>
    <div class="col-lg-6">
      <div class="card p-4">
        <div class="fw-bold"><?= e($n['title']) ?></div>
        <div class="small-muted mt-1"><?= e($n['created_at']) ?></div>
        <div class="mt-3"><?= nl2br(e($n['content'])) ?></div>
      </div>
    </div>
  <?php endforeach; ?>
  <?php if(!$rows): ?><div class="col-12"><div class="card p-4 text-center text-muted">No notices.</div></div><?php endif; ?>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
