<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('student');
csrf_verify();
$pdo = db();
$user = current_user();

$st = $pdo->prepare("SELECT s.*, c.name as class_name, sec.name as section_name
                     FROM students s
                     JOIN classes c ON c.id=s.class_id
                     JOIN sections sec ON sec.id=s.section_id
                     WHERE s.id=?");
$st->execute([(int)$user['profile_id']]);
$profile = $st->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $phone = trim($_POST['phone']);
  $email = trim($_POST['email']);
  $address = trim($_POST['address']);
  $pdo->beginTransaction();
  $pdo->prepare("UPDATE students SET phone=?, email=?, address=? WHERE id=?")
      ->execute([$phone,$email,$address,(int)$user['profile_id']]);
  $pdo->prepare("UPDATE users SET email=? WHERE id=?")->execute([$email,(int)$user['id']]);
  $pdo->commit();
  flash_set('success','Profile updated.');
  redirect('/student/profile.php');
}

$page_title = "Student Profile | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">My Profile</h3>
  <div class="small-muted">Update your contact details. Class/section are read-only.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>

<div class="card p-4" style="max-width:920px;">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">Name</label><input class="form-control" value="<?= e($profile['name']) ?>" disabled></div>
      <div class="col-md-3"><label class="form-label">Roll No.</label><input class="form-control" value="<?= e($profile['roll_number']) ?>" disabled></div>
      <div class="col-md-3"><label class="form-label">Username</label><input class="form-control" value="<?= e($user['username']) ?>" disabled></div>
      <div class="col-md-6"><label class="form-label">Class</label><input class="form-control" value="<?= e($profile['class_name']) ?>" disabled></div>
      <div class="col-md-6"><label class="form-label">Section</label><input class="form-control" value="<?= e($profile['section_name']) ?>" disabled></div>
      <div class="col-md-4"><label class="form-label">Phone</label><input class="form-control" name="phone" value="<?= e($profile['phone']) ?>"></div>
      <div class="col-md-8"><label class="form-label">Email</label><input class="form-control" type="email" name="email" value="<?= e($profile['email']) ?>"></div>
      <div class="col-12"><label class="form-label">Address</label><input class="form-control" name="address" value="<?= e($profile['address']) ?>"></div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/change_password.php">Change Password</a>
    </div>
  </form>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
