<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
csrf_verify();
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

function setting_get($pdo, $key, $default='') {
  $st = $pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$key]);
  $r = $st->fetch();
  return $r ? $r['value'] : $default;
}
$editDays = (int)setting_get($pdo,'edit_days','2');

$action = $_GET['action'] ?? 'list';
$sess_id = (int)($_GET['session_id'] ?? 0);
$date = $_GET['date'] ?? now_date();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'edit') {
  $sid = (int)$_POST['session_id'];
  $reason = trim($_POST['reason'] ?? '');

  $sess = $pdo->prepare("SELECT * FROM attendance_sessions WHERE id=? AND teacher_id=?");
  $sess->execute([$sid,$teacher_id]);
  $session = $sess->fetch();
  if (!$session) { flash_set('error','Session not found.'); redirect('/teacher/attendance.php'); }
  if ((int)$session['locked']===1) { flash_set('error','Session is locked.'); redirect('/teacher/attendance.php?action=view&session_id='.$sid); }

  $daysDiff = (strtotime(now_date()) - strtotime($session['attendance_date'])) / 86400;
  if ($daysDiff > $editDays) { flash_set('error','Edit window expired.'); redirect('/teacher/attendance.php?action=view&session_id='.$sid); }

  $statuses = $_POST['status'] ?? [];
  $remarks = $_POST['remark'] ?? [];

  $pdo->beginTransaction();
  foreach ($statuses as $student_id => $status) {
    $student_id = (int)$student_id;
    $remark = trim($remarks[$student_id] ?? '');
    $pdo->prepare("UPDATE attendance_entries
      SET status=?, remark=?, last_edit_reason=?, last_edited_by=?, last_edited_at=NOW()
      WHERE session_id=? AND student_id=?")
      ->execute([$status, $remark ?: null, $reason ?: null, (int)$user['id'], $sid, $student_id]);
  }
  $pdo->commit();
  flash_set('success','Attendance updated.');
  redirect('/teacher/attendance.php?action=view&session_id='.$sid);
}

$success = flash_get('success');
$error = flash_get('error');

if ($action === 'view' && $sess_id) {
  $sess = $pdo->prepare("SELECT s.*, c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                         FROM attendance_sessions s
                         JOIN classes c ON c.id=s.class_id
                         JOIN sections sec ON sec.id=s.section_id
                         JOIN subjects sub ON sub.id=s.subject_id
                         WHERE s.id=? AND s.teacher_id=?");
  $sess->execute([$sess_id,$teacher_id]);
  $session = $sess->fetch();

  $entries = $pdo->prepare("SELECT ae.*, st.name as student_name, st.roll_number
                            FROM attendance_entries ae
                            JOIN students st ON st.id=ae.student_id
                            WHERE ae.session_id=?
                            ORDER BY st.roll_number+0, st.roll_number");
  $entries->execute([$sess_id]);
  $entryRows = $entries->fetchAll();
}

$page_title = "Attendance | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Attendance View & Edit</h3>
    <div class="small-muted">You can edit within <?= e($editDays) ?> day(s) if not locked by admin.</div>
  </div>
  <a class="btn btn-primary" href="<?= BASE_URL ?>/teacher/mark.php">Mark Attendance</a>
</div>

<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<?php if ($action==='view' && !empty($session)): 
  $daysDiff = (strtotime(now_date()) - strtotime($session['attendance_date'])) / 86400;
  $canEdit = ((int)$session['locked']===0) && ($daysDiff <= $editDays);
?>
  <div class="card p-4 mb-3">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h5 class="fw-bold mb-1"><?= e($session['class_name'].' - '.$session['section_name']) ?> • <?= e($session['code'].' '.$session['subject_name']) ?></h5>
        <div class="small-muted">Date: <b><?= e($session['attendance_date']) ?></b></div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/teacher/attendance.php?date=<?= e($session['attendance_date']) ?>">Back</a>
        <?= ((int)$session['locked']===1)?'<span class="badge text-bg-warning align-self-center">Locked</span>':'<span class="badge text-bg-success align-self-center">Open</span>' ?>
      </div>
    </div>
  </div>

  <div class="card p-4">
    <?php if(!$canEdit): ?>
      <div class="alert alert-warning">Editing is not allowed (locked or edit window expired).</div>
    <?php endif; ?>
    <form method="post">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="edit">
      <input type="hidden" name="session_id" value="<?= e($session['id']) ?>">
      <div class="mb-3">
        <label class="form-label">Edit Reason</label>
        <input class="form-control" name="reason" placeholder="Recommended">
      </div>

      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Roll</th><th>Student</th><th>Status</th><th>Remark</th></tr></thead>
          <tbody>
            <?php foreach($entryRows as $r): ?>
              <tr>
                <td><?= e($r['roll_number']) ?></td>
                <td><?= e($r['student_name']) ?></td>
                <td style="max-width:260px;">
                  <select class="form-select" name="status[<?= e($r['student_id']) ?>]" <?= $canEdit?'':'disabled' ?>>
                    <option value="present" <?= ($r['status']==='present')?'selected':'' ?>>Present</option>
                    <option value="absent" <?= ($r['status']==='absent')?'selected':'' ?>>Absent</option>
                    <option value="leave" <?= ($r['status']==='leave')?'selected':'' ?>>Leave</option>
                  </select>
                </td>
                <td><input class="form-control" name="remark[<?= e($r['student_id']) ?>]" value="<?= e($r['remark']) ?>" <?= $canEdit?'':'disabled' ?>></td>
              </tr>
            <?php endforeach; ?>
            <?php if(!$entryRows): ?><tr><td colspan="4" class="text-center text-muted py-4">No entries.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>
      <?php if($canEdit): ?><button class="btn btn-primary">Save Changes</button><?php endif; ?>
    </form>
  </div>

<?php else:
  $st = $pdo->prepare("SELECT s.id, s.attendance_date, s.locked, c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                       FROM attendance_sessions s
                       JOIN classes c ON c.id=s.class_id
                       JOIN sections sec ON sec.id=s.section_id
                       JOIN subjects sub ON sub.id=s.subject_id
                       WHERE s.teacher_id=? AND s.attendance_date=?
                       ORDER BY c.name, sec.name, sub.name");
  $st->execute([$teacher_id,$date]);
  $rows = $st->fetchAll();
?>
  <div class="card p-3 mb-3">
    <form class="row g-2 p-2" method="get">
      <div class="col-md-4">
        <input type="date" class="form-control" name="date" value="<?= e($date) ?>">
      </div>
      <div class="col-md-8 d-flex gap-2">
        <button class="btn btn-outline-primary w-100">Load</button>
        <a class="btn btn-outline-secondary w-100" href="<?= BASE_URL ?>/teacher/attendance.php">Today</a>
      </div>
    </form>
  </div>

  <div class="card p-3">
    <div class="table-responsive">
      <table class="table align-middle">
        <thead><tr><th>Date</th><th>Class</th><th>Section</th><th>Subject</th><th>Status</th><th class="text-end">Action</th></tr></thead>
        <tbody>
          <?php foreach($rows as $r): ?>
            <tr>
              <td><?= e($r['attendance_date']) ?></td>
              <td><?= e($r['class_name']) ?></td>
              <td><?= e($r['section_name']) ?></td>
              <td><?= e($r['code'].' - '.$r['subject_name']) ?></td>
              <td><?= ((int)$r['locked']===1)?'<span class="badge text-bg-warning">Locked</span>':'<span class="badge text-bg-success">Open</span>' ?></td>
              <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/teacher/attendance.php?action=view&session_id=<?= e($r['id']) ?>">View</a></td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$rows): ?><tr><td colspan="6" class="text-center text-muted py-4">No sessions for selected date.</td></tr><?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
<?php endif; ?>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
