<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

$alloc = $pdo->prepare("SELECT a.*, c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                        FROM allocations a
                        JOIN classes c ON c.id=a.class_id
                        JOIN sections sec ON sec.id=a.section_id
                        JOIN subjects sub ON sub.id=a.subject_id
                        WHERE a.teacher_id=?
                        ORDER BY c.name, sec.name, sub.name");
$alloc->execute([$teacher_id]);
$allocRows = $alloc->fetchAll();

$today = now_date();
$todayStatus = $pdo->prepare("SELECT COUNT(*) total, SUM(CASE WHEN s.id IS NOT NULL THEN 1 ELSE 0 END) marked
                              FROM allocations a
                              LEFT JOIN attendance_sessions s 
                                ON s.class_id=a.class_id AND s.section_id=a.section_id AND s.subject_id=a.subject_id AND s.attendance_date=?
                              WHERE a.teacher_id=?");
$todayStatus->execute([$today,$teacher_id]);
$ts = $todayStatus->fetch() ?: ['total'=>0,'marked'=>0];

$page_title = "Teacher Dashboard | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Teacher Dashboard</h3>
    <div class="small-muted">Assigned classes/subjects and today's marking status.</div>
  </div>
  <a class="btn btn-primary" href="<?= BASE_URL ?>/teacher/mark.php">Mark Attendance</a>
</div>

<div class="row g-3 mb-3">
  <div class="col-md-6">
    <div class="card p-4">
      <h5 class="fw-bold mb-1">Today's Status</h5>
      <div class="small-muted">Date: <?= e(today_dmy()) ?></div>
      <div class="mt-3">
        <div class="d-flex align-items-center justify-content-between">
          <div>Total assigned allocations</div>
          <div class="fw-bold"><?= e((int)$ts['total']) ?></div>
        </div>
        <div class="d-flex align-items-center justify-content-between">
          <div>Marked today</div>
          <div class="fw-bold"><?= e((int)$ts['marked']) ?></div>
        </div>
      </div>
      <div class="mt-3">
        <?php if ((int)$ts['total']>0 && (int)$ts['marked']<(int)$ts['total'): ?>
          <div class="alert alert-warning mb-0">Some allocations are not marked yet today.</div>
        <?php else: ?>
          <div class="alert alert-success mb-0">All allocations marked for today.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card p-4">
      <h5 class="fw-bold mb-1">Quick Links</h5>
      <div class="d-grid gap-2 mt-3">
        <a class="btn btn-outline-primary" href="<?= BASE_URL ?>/teacher/mark.php">Mark Attendance</a>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/teacher/attendance.php">View / Edit Attendance</a>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/teacher/reports.php">Reports (CSV)</a>
      </div>
    </div>
  </div>
</div>

<div class="card p-3">
  <div class="d-flex align-items-center justify-content-between">
    <h5 class="fw-bold mb-0">Assigned Allocations</h5>
    <div class="small-muted">You can only mark for assigned items.</div>
  </div>
  <div class="table-responsive mt-3">
    <table class="table align-middle">
      <thead><tr><th>Class</th><th>Section</th><th>Subject</th><th class="text-end">Action</th></tr></thead>
      <tbody>
        <?php foreach($allocRows as $a): ?>
          <tr>
            <td><?= e($a['class_name']) ?></td>
            <td><?= e($a['section_name']) ?></td>
            <td><?= e($a['code'].' - '.$a['subject_name']) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/teacher/mark.php?alloc_id=<?= e($a['id']) ?>">Mark</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$allocRows): ?><tr><td colspan="4" class="text-center text-muted py-4">No allocations assigned.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
