<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

$classSecs = $pdo->prepare("SELECT DISTINCT a.class_id, a.section_id FROM allocations a WHERE a.teacher_id=?");
$classSecs->execute([$teacher_id]);
$allowed = $classSecs->fetchAll();
$allowedSet = [];
foreach($allowed as $x){ $allowedSet[$x['class_id'].'-'.$x['section_id']] = true; }

$rows = $pdo->query("SELECT lr.*, s.name as student_name, s.roll_number, c.name as class_name, sec.name as section_name
                     FROM leave_requests lr
                     JOIN students s ON s.id=lr.student_id
                     JOIN classes c ON c.id=s.class_id
                     JOIN sections sec ON sec.id=s.section_id
                     ORDER BY lr.created_at DESC")->fetchAll();

$filtered = array_values(array_filter($rows, function($r) use ($allowedSet){
  return isset($allowedSet[$r['class_id'].'-'.$r['section_id']]);
}));

$page_title = "Leave Requests | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Leave Requests (View)</h3>
  <div class="small-muted">View leave requests from your assigned class/section students. Admin handles approvals.</div>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>Student</th><th>Class</th><th>From</th><th>To</th><th>Reason</th><th>Status</th></tr></thead>
      <tbody>
        <?php foreach($filtered as $r): ?>
          <tr>
            <td>
              <div class="fw-semibold"><?= e($r['student_name']) ?></div>
              <div class="small-muted">Roll: <?= e($r['roll_number']) ?></div>
            </td>
            <td><?= e($r['class_name'].' - '.$r['section_name']) ?></td>
            <td><?= e($r['date_from']) ?></td>
            <td><?= e($r['date_to']) ?></td>
            <td><?= e($r['reason']) ?></td>
            <td><?= e($r['status']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$filtered): ?><tr><td colspan="6" class="text-center text-muted py-4">No requests.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
