<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
csrf_verify();
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

function setting_get($pdo, $key, $default='') {
  $st = $pdo->prepare("SELECT value FROM settings WHERE `key`=?");
  $st->execute([$key]);
  $r = $st->fetch();
  return $r ? $r['value'] : $default;
}

$allocRows = $pdo->prepare("SELECT a.id, a.class_id, a.section_id, a.subject_id,
                            c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                            FROM allocations a
                            JOIN classes c ON c.id=a.class_id
                            JOIN sections sec ON sec.id=a.section_id
                            JOIN subjects sub ON sub.id=a.subject_id
                            WHERE a.teacher_id=?
                            ORDER BY c.name, sec.name, sub.name");
$allocRows->execute([$teacher_id]);
$allocations = $allocRows->fetchAll();

$alloc_id = (int)($_GET['alloc_id'] ?? ($_POST['alloc_id'] ?? 0));
$date = $_GET['date'] ?? ($_POST['date'] ?? now_date());

$selectedAlloc = null;
foreach ($allocations as $a) { if ((int)$a['id']===$alloc_id) { $selectedAlloc = $a; break; } }

$success = flash_get('success');
$error = flash_get('error');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save') {
  if (!$selectedAlloc) { flash_set('error','Invalid allocation.'); redirect('/teacher/mark.php'); }
  $class_id = (int)$selectedAlloc['class_id'];
  $section_id = (int)$selectedAlloc['section_id'];
  $subject_id = (int)$selectedAlloc['subject_id'];

  // Check existing session
  $st = $pdo->prepare("SELECT * FROM attendance_sessions WHERE class_id=? AND section_id=? AND subject_id=? AND attendance_date=?");
  $st->execute([$class_id,$section_id,$subject_id,$date]);
  $session = $st->fetch();

  if ($session && (int)$session['locked']===1) {
    flash_set('error','Attendance is locked for this session.');
    redirect('/teacher/mark.php?alloc_id='.$alloc_id.'&date='.$date);
  }

  if (!$session) {
    // create session
    try {
      $pdo->prepare("INSERT INTO attendance_sessions (teacher_id,class_id,section_id,subject_id,attendance_date,locked) VALUES (?,?,?,?,?,0)")
          ->execute([$teacher_id,$class_id,$section_id,$subject_id,$date]);
      $session_id = (int)$pdo->lastInsertId();
    } catch(Exception $e) {
      // unique constraint - another created
      $st->execute([$class_id,$section_id,$subject_id,$date]);
      $session = $st->fetch();
      $session_id = (int)$session['id'];
    }
  } else {
    $session_id = (int)$session['id'];
  }

  // Prevent duplicate marking: if entries exist, treat as update
  $entriesExists = $pdo->prepare("SELECT COUNT(*) c FROM attendance_entries WHERE session_id=?");
  $entriesExists->execute([$session_id]);
  $hasEntries = (int)$entriesExists->fetch()['c']>0;

  $statuses = $_POST['status'] ?? [];
  $remarks = $_POST['remark'] ?? [];

  // Fetch approved leaves for date
  $leaveSt = $pdo->prepare("SELECT student_id FROM leave_requests WHERE status='approved' AND ? BETWEEN date_from AND date_to");
  $leaveSt->execute([$date]);
  $leaveStudents = array_flip(array_map(fn($r)=>$r['student_id'], $leaveSt->fetchAll()));

  $pdo->beginTransaction();
  foreach ($statuses as $student_id => $status) {
    $student_id = (int)$student_id;
    $remark = trim($remarks[$student_id] ?? '');
    // Auto leave if approved leave covers date
    if (isset($leaveStudents[$student_id]) && $status !== 'present') {
      $status = 'leave';
      if (!$remark) $remark = 'Approved leave';
    }
    if ($hasEntries) {
      $pdo->prepare("UPDATE attendance_entries SET status=?, remark=? WHERE session_id=? AND student_id=?")
          ->execute([$status, $remark ?: null, $session_id, $student_id]);
    } else {
      $pdo->prepare("INSERT INTO attendance_entries (session_id,student_id,status,remark) VALUES (?,?,?,?)")
          ->execute([$session_id,$student_id,$status,$remark ?: null]);
    }
  }
  $pdo->commit();

  flash_set('success', $hasEntries ? 'Attendance updated.' : 'Attendance saved.');
  redirect('/teacher/attendance.php?action=view&session_id='.$session_id);
}

$students = [];
$already = null;
$locked = 0;

if ($selectedAlloc) {
  $class_id = (int)$selectedAlloc['class_id'];
  $section_id = (int)$selectedAlloc['section_id'];
  $subject_id = (int)$selectedAlloc['subject_id'];

  $st = $pdo->prepare("SELECT * FROM attendance_sessions WHERE class_id=? AND section_id=? AND subject_id=? AND attendance_date=?");
  $st->execute([$class_id,$section_id,$subject_id,$date]);
  $already = $st->fetch();
  $locked = $already ? (int)$already['locked'] : 0;

  $studentsSt = $pdo->prepare("SELECT id, name, roll_number FROM students WHERE class_id=? AND section_id=? ORDER BY roll_number+0, roll_number");
  $studentsSt->execute([$class_id,$section_id]);
  $students = $studentsSt->fetchAll();

  $existingStatuses = [];
  $existingRemarks = [];
  if ($already) {
    $e = $pdo->prepare("SELECT * FROM attendance_entries WHERE session_id=?");
    $e->execute([(int)$already['id']]);
    foreach ($e->fetchAll() as $r) { $existingStatuses[(int)$r['student_id']] = $r['status']; $existingRemarks[(int)$r['student_id']] = $r['remark']; }
  }
}

$page_title = "Mark Attendance | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h3 class="fw-bold mb-0">Mark Attendance</h3>
    <div class="small-muted">Select allocation and date, then mark students as Present/Absent/Leave.</div>
  </div>
  <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/teacher/index.php">Dashboard</a>
</div>

<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>
<?php if ($error): ?><div class="alert alert-danger" data-auto-dismiss="1"><?= e($error) ?></div><?php endif; ?>

<div class="card p-4 mb-3">
  <form method="get" class="row g-2">
    <div class="col-md-8">
      <label class="form-label">Allocation</label>
      <select class="form-select" name="alloc_id" required>
        <option value="">Select</option>
        <?php foreach($allocations as $a): ?>
          <option value="<?= e($a['id']) ?>" <?= ($alloc_id===(int)$a['id'])?'selected':'' ?>>
            <?= e($a['class_name'].' - '.$a['section_name'].' • '.$a['code'].' - '.$a['subject_name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Date</label>
      <div class="input-group">
        <input type="date" class="form-control" name="date" value="<?= e($date) ?>">
        <button class="btn btn-outline-primary">Load</button>
      </div>
    </div>
  </form>

  <?php if ($already): ?>
    <div class="mt-3">
      <?php if ($locked): ?>
        <div class="alert alert-warning mb-0">Already marked for this date, and it is locked. You cannot edit.</div>
      <?php else: ?>
        <div class="alert alert-info mb-0">Already marked for this date. Saving will update existing entries.</div>
      <?php endif; ?>
    </div>
  <?php endif; ?>
</div>

<?php if ($selectedAlloc): ?>
  <div class="card p-4">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h5 class="fw-bold mb-0"><?= e($selectedAlloc['class_name'].' - '.$selectedAlloc['section_name']) ?> • <?= e($selectedAlloc['code'].' '.$selectedAlloc['subject_name']) ?></h5>
        <div class="small-muted">Date: <b><?= e($date) ?></b></div>
      </div>
      <div>
        <?php if ($locked): ?><span class="badge text-bg-warning">Locked</span><?php endif; ?>
      </div>
    </div>

    <form method="post" class="mt-3">
      <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="action" value="save">
      <input type="hidden" name="alloc_id" value="<?= e($alloc_id) ?>">
      <input type="hidden" name="date" value="<?= e($date) ?>">

      <div class="table-responsive">
        <table class="table align-middle">
          <thead><tr><th>Roll</th><th>Student</th><th>Status</th><th>Remark</th></tr></thead>
          <tbody>
          <?php foreach($students as $st): 
            $sid = (int)$st['id'];
            $cur = $existingStatuses[$sid] ?? 'present';
            $rem = $existingRemarks[$sid] ?? '';
          ?>
            <tr>
              <td><?= e($st['roll_number']) ?></td>
              <td><?= e($st['name']) ?></td>
              <td style="max-width:260px;">
                <select class="form-select" name="status[<?= e($sid) ?>]" <?= $locked?'disabled':'' ?>>
                  <option value="present" <?= ($cur==='present')?'selected':'' ?>>Present</option>
                  <option value="absent" <?= ($cur==='absent')?'selected':'' ?>>Absent</option>
                  <option value="leave" <?= ($cur==='leave')?'selected':'' ?>>Leave</option>
                </select>
              </td>
              <td><input class="form-control" name="remark[<?= e($sid) ?>]" value="<?= e($rem) ?>" <?= $locked?'disabled':'' ?>></td>
            </tr>
          <?php endforeach; ?>
          <?php if(!$students): ?><tr><td colspan="4" class="text-center text-muted py-4">No students in this class/section.</td></tr><?php endif; ?>
          </tbody>
        </table>
      </div>

      <?php if (!$locked && $students): ?>
        <button class="btn btn-primary">Save Attendance</button>
      <?php endif; ?>
    </form>
  </div>
<?php endif; ?>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
