<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
csrf_verify();
$pdo = db();
$user = current_user();

$st = $pdo->prepare("SELECT * FROM teachers WHERE id=?");
$st->execute([(int)$user['profile_id']]);
$profile = $st->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name']);
  $email = trim($_POST['email']);
  $phone = trim($_POST['phone']);
  $address = trim($_POST['address']);
  $designation = trim($_POST['designation']);
  $pdo->beginTransaction();
  $pdo->prepare("UPDATE teachers SET name=?, email=?, phone=?, address=?, designation=? WHERE id=?")
      ->execute([$name,$email,$phone,$address,$designation,(int)$user['profile_id']]);
  $pdo->prepare("UPDATE users SET name=?, email=? WHERE id=?")->execute([$name,$email,(int)$user['id']]);
  $pdo->commit();
  flash_set('success','Profile updated.');
  redirect('/teacher/profile.php');
}

$page_title = "Teacher Profile | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
$success = flash_get('success');
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Teacher Profile</h3>
  <div class="small-muted">Update your profile details.</div>
</div>
<?php if ($success): ?><div class="alert alert-success" data-auto-dismiss="1"><?= e($success) ?></div><?php endif; ?>

<div class="card p-4" style="max-width:920px;">
  <form method="post">
    <input type="hidden" name="_token" value="<?= e(csrf_token()) ?>">
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">Name</label><input class="form-control" name="name" value="<?= e($profile['name']) ?>" required></div>
      <div class="col-md-6"><label class="form-label">Email</label><input class="form-control" type="email" name="email" value="<?= e($profile['email']) ?>" required></div>
      <div class="col-md-4"><label class="form-label">Phone</label><input class="form-control" name="phone" value="<?= e($profile['phone']) ?>"></div>
      <div class="col-md-4"><label class="form-label">Designation</label><input class="form-control" name="designation" value="<?= e($profile['designation']) ?>"></div>
      <div class="col-md-4"><label class="form-label">Username</label><input class="form-control" value="<?= e($user['username']) ?>" disabled></div>
      <div class="col-12"><label class="form-label">Address</label><input class="form-control" name="address" value="<?= e($profile['address']) ?>"></div>
    </div>
    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary">Save</button>
      <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/change_password.php">Change Password</a>
    </div>
  </form>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
