<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../includes/reporting.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

$alloc = $pdo->prepare("SELECT a.id, a.class_id, a.section_id, a.subject_id,
                        c.name as class_name, sec.name as section_name, sub.code, sub.name as subject_name
                        FROM allocations a
                        JOIN classes c ON c.id=a.class_id
                        JOIN sections sec ON sec.id=a.section_id
                        JOIN subjects sub ON sub.id=a.subject_id
                        WHERE a.teacher_id=?
                        ORDER BY c.name, sec.name, sub.name");
$alloc->execute([$teacher_id]);
$allocs = $alloc->fetchAll();

$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? now_date();
$alloc_id = (int)($_GET['alloc_id'] ?? 0);
$export = (int)($_GET['export'] ?? 0);

$rows = [];
if (isset($_GET['run']) && $alloc_id) {
  $sel = null;
  foreach($allocs as $a) if ((int)$a['id']===$alloc_id) $sel=$a;
  if ($sel) {
    $st = $pdo->prepare("SELECT s.attendance_date, st.roll_number, st.name as student_name, ae.status, ae.remark
                         FROM attendance_entries ae
                         JOIN attendance_sessions s ON s.id=ae.session_id
                         JOIN students st ON st.id=ae.student_id
                         WHERE s.teacher_id=? AND s.class_id=? AND s.section_id=? AND s.subject_id=?
                           AND s.attendance_date BETWEEN ? AND ?
                         ORDER BY s.attendance_date, st.roll_number+0, st.roll_number");
    $st->execute([$teacher_id,(int)$sel['class_id'],(int)$sel['section_id'],(int)$sel['subject_id'],$from,$to]);
    $rows = $st->fetchAll();
    if ($export) {
      csv_download("teacher_report.csv", ["Date","Roll","Student","Status","Remark"],
        array_map(fn($r)=>[$r['attendance_date'],$r['roll_number'],$r['student_name'],$r['status'],$r['remark']], $rows));
    }
  }
}

$page_title = "Reports | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Reports (Teacher Scope)</h3>
  <div class="small-muted">Generate date-wise attendance and export as CSV for assigned allocations.</div>
</div>

<div class="card p-4 mb-3">
  <form method="get" class="row g-2">
    <div class="col-md-6">
      <label class="form-label">Allocation</label>
      <select class="form-select" name="alloc_id" required>
        <option value="">Select</option>
        <?php foreach($allocs as $a): ?>
          <option value="<?= e($a['id']) ?>" <?= ($alloc_id===(int)$a['id'])?'selected':'' ?>>
            <?= e($a['class_name'].' - '.$a['section_name'].' • '.$a['code'].' - '.$a['subject_name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">From</label>
      <input type="date" class="form-control" name="from" value="<?= e($from) ?>">
    </div>
    <div class="col-md-3">
      <label class="form-label">To</label>
      <input type="date" class="form-control" name="to" value="<?= e($to) ?>">
    </div>
    <div class="col-md-6">
      <label class="form-label">CSV Export</label>
      <select class="form-select" name="export">
        <option value="0">No</option>
        <option value="1">Yes (Download)</option>
      </select>
    </div>
    <div class="col-md-6 d-flex align-items-end gap-2">
      <button class="btn btn-primary w-100" name="run" value="1">Generate</button>
      <button class="btn btn-outline-secondary w-100" onclick="window.print(); return false;">Print</button>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>Date</th><th>Roll</th><th>Student</th><th>Status</th><th>Remark</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= e($r['attendance_date']) ?></td>
            <td><?= e($r['roll_number']) ?></td>
            <td><?= e($r['student_name']) ?></td>
            <td><?= e($r['status']) ?></td>
            <td><?= e($r['remark']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows && isset($_GET['run'])): ?><tr><td colspan="5" class="text-center text-muted py-4">No data found.</td></tr>
        <?php elseif(!isset($_GET['run'])): ?><tr><td colspan="5" class="text-center text-muted py-4">Generate a report using filters above.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
