<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_once __DIR__ . '/../../config/db.php';
require_login('teacher');
$pdo = db();
$user = current_user();
$teacher_id = (int)$user['profile_id'];

$q = trim($_GET['q'] ?? '');
$allocs = $pdo->prepare("SELECT DISTINCT a.class_id, a.section_id, c.name as class_name, sec.name as section_name
                         FROM allocations a
                         JOIN classes c ON c.id=a.class_id
                         JOIN sections sec ON sec.id=a.section_id
                         WHERE a.teacher_id=?
                         ORDER BY c.name, sec.name");
$allocs->execute([$teacher_id]);
$classSecs = $allocs->fetchAll();

$class_id = (int)($_GET['class_id'] ?? ($classSecs[0]['class_id'] ?? 0));
$section_id = (int)($_GET['section_id'] ?? ($classSecs[0]['section_id'] ?? 0));

$sql = "SELECT s.*, c.name as class_name, sec.name as section_name
        FROM students s
        JOIN classes c ON c.id=s.class_id
        JOIN sections sec ON sec.id=s.section_id
        WHERE s.class_id=? AND s.section_id=?";
$params = [$class_id,$section_id];
if ($q) {
  $sql .= " AND (s.name LIKE ? OR s.roll_number LIKE ?)";
  $params[] = "%$q%"; $params[]="%$q%";
}
$sql .= " ORDER BY s.roll_number+0, s.roll_number";

$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

$page_title = "Students | " . APP_NAME;
include __DIR__ . '/../../includes/layout_head.php';
include __DIR__ . '/../../includes/dashboard_shell.php';
?>
<div class="mb-3">
  <h3 class="fw-bold mb-0">Students (Assigned Classes Only)</h3>
  <div class="small-muted">Search by roll number or name.</div>
</div>

<div class="card p-3 mb-3">
  <form class="row g-2 p-2" method="get">
    <div class="col-md-4">
      <select class="form-select" name="class_id" required>
        <?php foreach($classSecs as $cs): ?>
          <option value="<?= e($cs['class_id']) ?>" <?= ($class_id===(int)$cs['class_id'])?'selected':'' ?>><?= e($cs['class_name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <select class="form-select" name="section_id" required>
        <?php foreach($classSecs as $cs): ?>
          <?php if ((int)$cs['class_id']===$class_id): ?>
            <option value="<?= e($cs['section_id']) ?>" <?= ($section_id===(int)$cs['section_id'])?'selected':'' ?>><?= e($cs['section_name']) ?></option>
          <?php endif; ?>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-5">
      <div class="input-group">
        <input class="form-control" name="q" value="<?= e($q) ?>" placeholder="Search by roll or name">
        <button class="btn btn-outline-primary">Search</button>
        <a class="btn btn-outline-secondary" href="<?= BASE_URL ?>/teacher/students.php">Reset</a>
      </div>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table align-middle">
      <thead><tr><th>Roll</th><th>Name</th><th>Phone</th><th>Email</th><th>Address</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= e($r['roll_number']) ?></td>
            <td><?= e($r['name']) ?></td>
            <td><?= e($r['phone']) ?></td>
            <td><?= e($r['email']) ?></td>
            <td><?= e($r['address']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if(!$rows): ?><tr><td colspan="5" class="text-center text-muted py-4">No students found.</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
include __DIR__ . '/../../includes/dashboard_shell_end.php';
include __DIR__ . '/../../includes/layout_foot.php';
?>
